"use strict";

import {handleCollapseCardHeaderOnClick} from './common.js';
import {checkInvalidCharacterInItem} from './common.js';
import {handleInputLabels} from './common.js';
import {convertDatetimeToLocaleString, getFilterDateInputValue} from './common.js';
import {toggleLoadingIcon} from './common.js';
import {getHistoryTable} from './component/history_table.js';
import {getHistoryModal} from './component/history_modal.js';
import {getNameFromMessageType} from './model/sysrpt_model.js';

export const History = (store, actions, tabname) => {
  const inst = {};
  inst.store = store;
  inst.actions = actions;
  inst.tag = store.getState().tag;
  inst.store.subscribe((action) => {
    const {tab} = inst.store.getState();
    if (tabname && tab !== tabname) {
      return;
    }
    if (action.type === 'SET_RECORDS') {
      const {records} = inst.store.getState();
      const container = document.querySelector(`[data-${inst.tag}='content']`).querySelector(`[data-${inst.tag}-history='table']`);
      inst.table.buildTable(container, records);
    } else if (action.type === 'SET_TOTAL_PAGES') {
      const {totalPages, page, size} = inst.store.getState();
      const container = document.querySelector(`[data-${inst.tag}='content']`).querySelector(`[data-${inst.tag}-history='table']`);
      inst.table.buildPagination(container, page, size, totalPages);
    } else if (action.type === 'SET_TOTAL_RECORDS') {
      const {totalRecords} = inst.store.getState();
      inst.table.setTotalRecordCount(totalRecords);
    } else if (action.type === 'SET_DETAIL') {
      const {detail} = inst.store.getState();
      inst.previewModal.buildModalContent(detail);
    } else if (action.type === 'SET_RECORD_LOADING') {
      const {tab, recordLoading} = inst.store.getState();
      const table = document.querySelector(`[data-${inst.tag}-${tab}='table']`);
      const tableLoading = table?.querySelector("[data-table='loading']");
      toggleLoadingIcon(tableLoading, recordLoading);
    }
  });
  inst.table = Object.create(getHistoryTable());
  inst.setTable = () => {
    inst.table.fillHistoryTableRow = function(cols, rec) {
      // Handle messageId
      cols[0].textContent = rec.messageId;
      const msgTypeName = getNameFromMessageType(rec.messageType);
      const msgtypeSpan = document.getElementById(`${inst.tag}-history-span-template`).cloneNode(true).content;
      Array.from(msgtypeSpan.children).filter(c => c.getAttribute(`data-${inst.tag}-span`) !== msgTypeName).forEach(elem => {
        elem.remove();
      });
      if (msgtypeSpan.children.length) {
        cols[1].appendChild(msgtypeSpan);
      } else {
        cols[1].textContent = rec.messageType;
      }
      const filename = rec.filename ? rec.filename : `system_report_${rec.messageId}`;
      cols[2].textContent = filename;
      cols[3].textContent = convertDatetimeToLocaleString(rec.createDatetime);
      const downloadBtnOnClick = (mId, fname) => {
        console.log(mId, fname);
        if (mId) {
          inst.store.dispatch(inst.actions.getFile(mId, fname));
        }
      };
      const downloadBtnContainer = document.getElementById(`${inst.tag}-history-download-button-template`).cloneNode(true).content;
      const downloadBtn = downloadBtnContainer.querySelector("button");
      downloadBtn.addEventListener('click', () => downloadBtnOnClick(rec.messageId, filename));
      cols[4].appendChild(downloadBtnContainer);

      const previewBtnContainer = document.getElementById(`${inst.tag}-history-preview-button-template`).cloneNode(true).content;
      const previewBtn = previewBtnContainer.querySelector("button");
      previewBtn.addEventListener('click', () => inst.previewModal.handleHistoryModalOnToggle({messageId: rec.messageId, filename: rec.filename}));
      cols[5].appendChild(previewBtnContainer);
    };
    inst.table.setPage = function(page) {
      inst.store.dispatch(inst.actions.setPage(page))
    };
    inst.table.setSize = function(size) {
      inst.store.dispatch(inst.actions.setSize(size))
    };
  };
  inst.previewModal = Object.create(getHistoryModal());
  inst.setPreviewModal = () => {
    const modal = inst.previewModal
    const {tab} = inst.store.getState();
    const container = document.querySelector(`[data-${inst.tag}='content']`).querySelector("#detail-modal");
    modal.setContainer(container);
    const template = document.getElementById(`preview-modal-content-template`);
    modal.setTemplate(template);
    modal.onActivate = function(params) {
      inst.store.dispatch(inst.actions.getDetail(params.messageId, params.filenmae));
    };
    modal.renderModalContent = function(content, detail) {
      if (detail) {
        content.querySelector(`[data-${inst.tag}-modal='noPreview']`)?.remove();
        const pre = content.querySelector("pre");
        if (pre) {
          pre.textContent = detail;
        }
      }
    };
    modal.renderModalFooter = function(container, detail) {}
  };
  inst.buildFilter = () => {
    const queryParams = ['messageId', 'fileName', 'createDatetimeFrom', 'createDatetimeTo'];
    const handleQueryInputOnChange = (name, target) => {
      let value;
      if (target.tagName === 'INPUT') {
        if (target.type === 'text') {
          value = target.value;
        } else if (target.type === 'checkbox') {
          value = target.checked;
        } else if (target.type === 'datetime-local' || target.type === 'date') {
          value = getFilterDateInputValue(name, target.value);
        }
      } else if (target.tagName === 'SELECT') {
        value = target.value;
      }
      const card = document.querySelector(`[data-${inst.tag}='content']`).querySelector(`[data-${inst.tag}-history='filter']`);
      const labelContainer = card.querySelector(`[data-${inst.tag}-filter='${name}']`);
      handleInputLabels(labelContainer, value, target.tagName);
      inst.store.dispatch(inst.actions.setQuery({[name]: value}));
    };
    const handleSearchButtonOnClick = () => {
      const {recordLoading} = inst.store.getState();
      if (recordLoading) {
        return;
      }
      if (!inst.isSearchButtonActive()) {
        return;
      }
      inst.store.dispatch(inst.actions.setPage());
    };
    const handleClearButtonOnClick = () => {
      const {recordLoading} = inst.store.getState();
      if (recordLoading) {
        return;
      }
      queryParams.forEach(q => {
        const fieldContainer = card.querySelector(`[data-${inst.tag}-filter='${q}']`);
        const inputs = Array.from(fieldContainer.querySelectorAll("input"));
        if (inputs && inputs.length) {
          inputs.forEach(input => {
            if (input.type === 'checkbox') {
              input.checked = false;
            } else {
              input.value = null;
            }
          });
        }
        const select = fieldContainer.querySelector("select");
        if (select) {
          select.selectedIndex = -1;
        }
      });
      const boxLabels = card.querySelectorAll("[data-dropdown='box']")
      boxLabels.forEach(elem => {
        elem.querySelector('p').innerHTML = "";
      });
      inst.store.dispatch(inst.actions.clearQuery());
      inst.store.dispatch(inst.actions.getRecords());
    };
    const buildCollapseCard = (card) => {
      const header = card.querySelector("[data-collapsecard='header']");
      header.addEventListener('click', () => handleCollapseCardHeaderOnClick(card));
    };
    const renderFilterContent = (card) => {
      queryParams.forEach(q => {
        const fieldContainer = card.querySelector(`[data-${inst.tag}-filter='${q}']`);
        const input = fieldContainer?.querySelector("input");
        if (input) {
          input.addEventListener("change", (e) => handleQueryInputOnChange(q, e.target));
        }
        const select = fieldContainer?.querySelector("select");
        if (select) {
          select.selectedIndex = -1;
          select.addEventListener("change", (e) => handleQueryInputOnChange(q, e.target));
        }
      });
    };
    inst.isSearchButtonActive = () => {
      const {query} = store.getState();
      const checkInvalidCharacterFields = ["messageId", "fileName"];
      let isActive = checkInvalidCharacterInItem(query, checkInvalidCharacterFields);
      return isActive;
    };
    const card = document.querySelector(`[data-${inst.tag}='content']`).querySelector(`[data-${inst.tag}-history='filter']`);
    buildCollapseCard(card);
    renderFilterContent(card);
    const searchButton = card.querySelector("#history-filter-search");
    searchButton.addEventListener("click", handleSearchButtonOnClick);
    const clearButton = card.querySelector("#history-filter-clear");
    clearButton.addEventListener("click", handleClearButtonOnClick);
  };
  inst.initialize = () => {
    const {tag} = inst.store.getState();
    inst.tag = tag;
    inst.buildFilter();
    inst.setTable();
    inst.setPreviewModal();
    store.dispatch(inst.actions.getRecords());
  };
  // Table related method
  return inst;
};
