"use strict";

import {createStore} from './common.js';
import {checkRequiredFieldInItem, handleViewPasswordIconOnClick} from './common.js';
// import {isValidPassword, isAlphaNumeric, handleInputLabels} from './common.js';

const Page = () => {
  const inst = {};
  inst.buildPage = () => {
    const csrfInput = document.querySelector("[data-login-form='_csrf']");
    store.dispatch(actions.setChangeItem({_csrf: csrfInput.value}));

    const usernameInput = document.querySelector("[data-login-form='username']").querySelector("input");
    usernameInput.addEventListener("input", (e) => inst.handleInputOnChange("username", e.target.type, e.target.value));

    const pwInput = document.querySelector("[data-login-form='password']").querySelector("input");
    pwInput.value = "";
    pwInput.addEventListener("input", (e) => inst.handleInputOnChange("password", e.target.type, e.target.value));

    const viewpwIcons = document.querySelector("[data-login-form='viewpw']")
    const showpwIcon = viewpwIcons.querySelector("[data-form-viewpw='show']");
    const hidepwIcon = viewpwIcons.querySelector("[data-form-viewpw='hide']");
    showpwIcon.addEventListener("click", () => handleViewPasswordIconOnClick(true, pwInput, showpwIcon, hidepwIcon));
    hidepwIcon.addEventListener("click", () => handleViewPasswordIconOnClick(false, pwInput, showpwIcon, hidepwIcon));

    const submitButton = document.querySelector("[data-login-form='submit']").querySelector("button");
    submitButton.addEventListener("click", inst.handleSubmitButtonOnClick);
  };
  inst.handleInputOnChange = (name, type, value) => {
    // const labelContainer = document.querySelector(`[data-login-form='${name}']`);
    // handleInputLabels(labelContainer, value, type);

    store.dispatch(actions.setChangeItem({[name]: value}));

    const submitButton = document.querySelector("[data-login-form='submit']").querySelector("button");
  };
  inst.handleSubmitButtonOnClick = (e) => {
    e.preventDefault();
    if (!inst.isSubmitButtonActive()) {
      return
    }
    store.dispatch(actions.login());
  };
  inst.isSubmitButtonActive = () => {
    const {changeItem} = store.getState();
    return checkRequiredFieldInItem(changeItem, ['username', 'password']);
  };
  return inst;
};


// Redux architecture pieces
const actions = {
  setChangeItem: (item) => {
    return {
      type: 'SET_CHANGE_ITEM',
      payload: item,
    };
  },
  login: () => {
    return {
      type: 'LOGIN',
    };
  }
};

const initialState = {
  changeItem: {},
  failed: false,
};

const loginReducer = (state = initialState, action) => {
  switch (action.type) {
    case 'SET_CHANGE_ITEM':
      let changeItem = Object.assign(
         Object.assign({}, state.changeItem), action.payload);
      return Object.assign(Object.assign({}, state), {changeItem});

    case 'LOGIN':
      login(state.changeItem);
      return state;

    default:
      return state;
  }
};

const store = createStore(loginReducer);

const login = (data) => {
  const formData = new FormData();
  formData.append('username', data.username);
  formData.append('password', data.password);
  formData.append('_csrf', data._csrf);
  fetch('/login', {
    method: 'POST',
    body: formData,
  }).then(response => {
    if (response.redirected) {
      let url = response.url;
      // If redirect to login page again, add failed to url end
      if (url.match(/(?<=\/)[^/]+/g)[1] === 'portal') {
        window.location.href = url;
      } else if ((url.match(/[^/]+$/)[0]).startsWith('change-password') ) {
        window.location.href = url;
      } else if ((url.match(/[^/]+$/)[0]).startsWith('login') ) {
        url = url + '?failed'
        window.location.href = url;
      } else {
        window.location.href = '/portal';
      }
    }
  }).catch(error => {
    console.error(error);
  });
};
const page = Page();

const onPageInitialize = () => {
  page.buildPage();
};
document.addEventListener("DOMContentLoaded", onPageInitialize);
