"use strict";

import {store, actions} from './model/filemgmt_model.js';
import {onNavInitialize} from './common.js';
import {SymmetricKeyEnquiryRequest, LostSymmetricKeyEnquiryRequest} from './file_management.js';
import {ListingRequest, EncryptionCertificateEnquiryRequest} from './file_management.js';
import {CertificateUploadRequest, ParticipantPublicCertificateRevocationRequest} from './file_management.js';
import {ClientSecretRenewalNotification, ClientSecretAmendmentRequest} from './file_management.js';
import {MessageSigningKeyRequest, HistoricalMessageEnquiryRequest, HistoricalMessageResendRequest} from './file_management.js';
import {MiscellaneousBusinessNotificationRequest, ReportEnquiryRequest} from './file_management.js';
import {getBaseUploadForm} from './component/upload_form.js';
import {getBaseSelectFormPage} from './component/select_form_page.js';

const contents = {
  symkeyenq: SymmetricKeyEnquiryRequest(store, actions),
  lostkeyenq: LostSymmetricKeyEnquiryRequest(store, actions),
  cplist: ListingRequest('cplist', store, actions),
  cralist: ListingRequest('cralist', store, actions),
  enccertenq: EncryptionCertificateEnquiryRequest(store, actions),
  certupload: CertificateUploadRequest(store, actions),
  ppcertrevo: ParticipantPublicCertificateRevocationRequest(store, actions),
  csecrenew: ClientSecretRenewalNotification(store, actions),
  csecamend: ClientSecretAmendmentRequest(store, actions),
  msgskeyreq: MessageSigningKeyRequest(store, actions),
  hmsgenq: HistoricalMessageEnquiryRequest(store, actions),
  hmsgresend: HistoricalMessageResendRequest(store, actions),
  miscbusnoti: MiscellaneousBusinessNotificationRequest(store, actions),
  rptenq: ReportEnquiryRequest(store, actions),
};
const page = getBaseSelectFormPage(store, actions, contents);

document.addEventListener("DOMContentLoaded", function(){
  onNavInitialize();
  page.initialize();
});
