"use strict";

export const buildRoleCheckboxes = (tree, handler, container = document) => {
  const roleItems = container.querySelector("#role-checkboxes");
  const checkboxTemplate = document.getElementById("role-checkbox");
  const preOrderNodes = tree.preOrder();
  preOrderNodes.forEach(node => {
    const nodeName = node.getProperty("name");
    const depth = tree.getDepth(node);
    const roleItem = checkboxTemplate.cloneNode(true);
    const row = roleItem.content.querySelector("[data-role='row']");
    row.classList.add("pl-" + String(depth * 8));
    const input = roleItem.content.querySelector("input");
    input.addEventListener('click', () => handler(input, node.id));
    const label = roleItem.content.querySelector("label");
    label.textContent = nodeName;
    roleItems.appendChild(roleItem.content.firstElementChild);
  });
};

export const HandleCheckboxOnClick = (curStore, curActions) => {
  const ret = (element, id) => {
    let state;
    if (element.indeterminate) {
      state = 2;
    } else {
      state = element.checked ? 1 : 0;
    }
    curStore.dispatch(curActions.getRoleStates(id, state));
  };
  return ret;
};

export const renderStates = (roleStates, container = document) => {
  const roleItems = Array.from(container.querySelector("#role-checkboxes").children);
  roleItems.forEach((item, idx) => {
    const input = item.querySelector("input");
    if (roleStates[idx] === 0) {
      input.indeterminate = false;
      input.checked = false;
    } else if (roleStates[idx] === 1) {
      input.indeterminate = false;
      input.checked = true;
    } else {
      input.indeterminate = true;
    }
  });
  // On Render states, check update button active
  // const updateItemButton = document.querySelector("[data-usermgmt-form='updateitem']")?.querySelector("button");
  // if (updateItemButton) {
  //   updateItemButton.disabled = !usermgmt.isUpdateItemButtonActive();
  // }
};
