"use strict"

import {renderDisplayTableScrollButton} from '../common.js';

export const getHistoryTable = () => {
  const inst = {};
  inst.rowsPerPageSelectIndex = 0;
  inst.buildTable = function(oldContainer, records) {
    // Clean up table event listener
    const container = oldContainer.cloneNode(true);
    oldContainer.replaceWith(container);
    const tbody = container.getElementsByTagName("tbody")[0];
    tbody.innerHTML = "";
    records.forEach(rec => {
      const rowTemplate = document.getElementById("history-table-row-template").cloneNode(true);
      const row = rowTemplate.content.firstElementChild;
      const cols = row.children;
      this.fillHistoryTableRow(cols, rec);
      tbody.appendChild(row);
    });
    renderDisplayTableScrollButton(container);
  };
  inst.buildPagination = function(container, curPageNumber, size, totalPages) {
    const pagination = container.querySelector("[data-table='pagination']");
    // Remove old page
    const pages = pagination.querySelectorAll("[data-table-pagination='page']");
    pages.forEach(element => {
      element.parentNode.remove();
    });

    const oldPrev = pagination.querySelector("[data-table-pagination='previous']");
    const oldNext = pagination.querySelector("[data-table-pagination='next']");
    const prev = oldPrev.cloneNode(true);
    oldPrev.parentNode.replaceChild(prev, oldPrev);
    const next = oldNext.cloneNode(true);
    oldNext.parentNode.replaceChild(next, oldNext);

    if (curPageNumber > 0) {
      prev.addEventListener('click', () => this.handlePaginationButtonOnClick(curPageNumber - 1));
    }
    if (curPageNumber < totalPages - 1) {
      next.addEventListener('click', () => this.handlePaginationButtonOnClick(curPageNumber + 1));
    }

    const padlen = 3;
    Array.from(Array(totalPages).keys()).forEach(i => {
      if (totalPages > 9 &&
        (curPageNumber <= padlen && i >= 9 ||
          i < curPageNumber - padlen ||
          (curPageNumber > padlen && i > curPageNumber + padlen)) &&
        i !== totalPages - 1 && i !== 0) {
        return ;
      }
      let pageTemplateId;
      if ((i) === curPageNumber) { 
        pageTemplateId = "pagination-currentpage-template";
      } else {
        pageTemplateId = "pagination-page-template";
      }
      const pageTemplate = document.getElementById(pageTemplateId).cloneNode(true);
      const page = pageTemplate.content.querySelector("[data-table-pagination='page']");
      page.textContent = String(i + 1);
      if (i !== curPageNumber) { 
        page.addEventListener('click', () => this.handlePaginationButtonOnClick(i));
      }
      // Add skip page
      if (i === totalPages - 1 && totalPages > 9 && curPageNumber < totalPages - 1 - (padlen + 1)) {
        const skipTemplate = document.getElementById("pagination-skippage-template")?.cloneNode(true);
        if (skipTemplate) {
          next.parentNode.before(skipTemplate.content.firstElementChild);
        }
      }
      next.parentNode.parentNode.insertBefore(pageTemplate.content.firstElementChild, next.parentNode);
      // Add skip page
      if (i === 0 && totalPages > 9 && curPageNumber > padlen + 1) {
        const skipTemplate = document.getElementById("pagination-skippage-template")?.cloneNode(true);
        if (skipTemplate) {
          next.parentNode.before(skipTemplate.content.firstElementChild);
        }
      }
    })
    // rows per page
    const oldRowsPerPage = pagination.querySelector("[data-table-pagination='rowsPerPage']");
    const rowsPerPage = oldRowsPerPage.cloneNode(true);
    oldRowsPerPage.parentNode.replaceChild(rowsPerPage, oldRowsPerPage);
    const newSelect = rowsPerPage.querySelector("select");
    newSelect.addEventListener('change', (e) => this.handleRowsPerPageOnChange(e));
    newSelect.selectedIndex = this.rowsPerPageSelectIndex;

  };
  inst.buildExport = function(container, dispatchExportFunc) {
    // addon function to add export button
    const exportButton = container.querySelector("#history-export");
    exportButton.addEventListener('click', () => {
      let confirmation = confirm("Are you sure to export all records?");
      if (confirmation) {
        dispatchExportFunc();
      }
    });
  };
  inst.handlePaginationButtonOnClick = function(targetPageNumber) {
    this.setPage(targetPageNumber);
  };
  inst.handleRowsPerPageOnChange = function(e) {
    const newSize = e.target.value;
    this.setSize(newSize);
    inst.rowsPerPageSelectIndex = Array.from(e.target.querySelectorAll("option")).findIndex(option => option.value === newSize);
  }
  inst.setTotalRecordCount = function(totalRecords) {
    const container = document.getElementById("history-table-total-records");
    if (!!container) {
      if (!!totalRecords) {
        container.textContent = totalRecords;
      } else {
        container.textContent = "-";
      }
    }
  };
  inst.fillHistoryTableRow = function(cols, rec) {
    console.error("fillHistoryTableRow To be implemented");
  };
  inst.setPage = function(page) {
    console.error("setPage to be implemented");
  };
  inst.setSize = function(size) {
    console.error("setSize to be implemented");
  };
  return inst;
};
