"use strict";

import {convertUrlQueryParams} from '../common.js';

export const GetFullHistory = (curStore, curActions, urlPrefix) => {
  return (onComplete) => {
    const {query} = curStore.getState();
    const size = 500;
    const initialFullRecords = [];
    // Define handlers
    const dispatchLoading = (loading) => {
      const setLoading = curActions.setExportLoading !== undefined ? curActions.setExportLoading : curActions.setLoading;
      if (setLoading !== undefined) {
        curStore.dispatch(setLoading(loading));
      }
    };
    const errorHandler = (err = "") => {
      alert(`Export failed ${err}`)
      dispatchLoading(false);
    };
    const onGetFullRecordCompleted = (fullRecords) => {
      onComplete(fullRecords);
      dispatchLoading(false);
    };
    const getRecord = (newPage, fullRecords) => {
      const params = query;
      const page = newPage;
      const url = convertUrlQueryParams(urlPrefix, Object.assign({page, size}, params));
      fetch(url).then(response => {
        if (response.redirected) {
          window.location.href = response.url;
        } else {
          return response.json();
        }
      }).then(result => {
        if (result.result === "Success") {
          if (result.data && result.data.totalPages > 0) {
            // Push new record if any
            const newRecords = result.data.record ? result.data.record : [];
            if (newRecords.length) {
              Array.prototype.push.apply(fullRecords, newRecords);
            }
            // data.page: start with 0
            // data.totalPages > 0 if there is any record
            if (newPage === (result.data.totalPages - 1)) {
              // Condition of termination
              onGetFullRecordCompleted(fullRecords);
            } else {
              getRecord(newPage + 1, fullRecords);
            }
          } else {
            errorHandler()
          }
        } else {
          displayActionResponse(result);
        }
      }).catch(error => {
        console.error(error);
        dispatchLoading(false);
      });
    };

    dispatchLoading(true);
    getRecord(0, initialFullRecords);
  };
};

export const exportFullRecordCSV = (filename, headers, recArrs) => {
  // https://stackoverflow.com/questions/14964035/how-to-export-javascript-array-info-to-csv-on-client-side
  var rows = [headers];
  Array.prototype.push.apply(rows, recArrs);
  var processRow = function (row) {
      var finalVal = '';
      for (var j = 0; j < row.length; j++) {
          var innerValue = row[j] === null ? '' : row[j].toString();
          if (row[j] instanceof Date) {
              innerValue = row[j].toLocaleString();
          };
          var result = innerValue.replace(/"/g, '""');
          if (result.search(/("|,|\n)/g) >= 0)
              result = '"' + result + '"';
          if (j > 0)
              finalVal += ',';
          finalVal += result;
      }
      return finalVal + '\n';
  };

  var csvFile = '';
  for (var i = 0; i < rows.length; i++) {
      csvFile += processRow(rows[i]);
  }

  var blob = new Blob([csvFile], { type: 'text/csv;charset=utf-8;' });
  if (navigator.msSaveBlob) { // IE 10+
      navigator.msSaveBlob(blob, filename);
  } else {
      var link = document.createElement("a");
      if (link.download !== undefined) { // feature detection
          // Browsers that support HTML5 download attribute
          var url = URL.createObjectURL(blob);
          link.setAttribute("href", url);
          link.setAttribute("download", filename);
          link.style.visibility = 'hidden';
          document.body.appendChild(link);
          link.click();
          document.body.removeChild(link);
      }
  }
};

export const getReorderedHeadersAndRecArrs = (fullRecord, orderedHeader) => {
  const headers = Object.keys(fullRecord[0]).sort((a, b) => {
    let orderA = orderedHeader.indexOf(a);
    orderA = orderA >= 0 ? orderA : 99999;
    let orderB = orderedHeader.indexOf(b);
    orderB = orderB >= 0 ? orderB : 99999;
    return orderA - orderB;
  });
  const recArrs = fullRecord.map(d => {
    let rec = [];
    headers.forEach(h => {
      rec.push(d[h])
    });
    return rec;
  });
  return {headers, recArrs};
};
