"use strict";

import {handleInputLabels, handleCollapseCardHeaderOnClick, handleModalOnToggleById} from '../common.js';

export const getBaseAccmgmt = (accmgmtType, store, actions) => {
  const inst = {};
  inst.name = 'getBaseAccmgmt';
  inst.type = accmgmtType;
  inst.store = store;
  inst.actions = actions;
  inst.initialize = function() {
    this.store.subscribe((action) => {
      if (action.type === 'SET_ITEMS') {
        const {items} = this.store.getState();
        this.buildContent(items);
      }
    });
    this.buildCollapseCard();
    this.store.dispatch(this.actions.getItems());
  };
  inst.buildCollapseCard = function() {
    const card = document.getElementById(`accmgmt-${this.type}`);
    const header = card.querySelector("[data-collapsecard='header']");
    header.addEventListener('click', () => this.handleCollapseCardHeaderOnClick(card));
    const addButton = card.querySelector("[data-collapsecard='add']")?.querySelector("button");
    if (!!addButton) {
      addButton.addEventListener('click', () => this.handleAddItemButtonOnClick());
    }
  };
  inst.buildContent = function(items) {
    const card = document.getElementById(`accmgmt-${this.type}`);
    const contentContainer = card.querySelector("[data-collapsecard='content-container']");
    contentContainer.innerHTML = "";
    items.forEach(item => {
      const contentTemplate = document.getElementById(`accmgmt-${this.type}-content-template`).cloneNode(true);

      // handle rendering common component
      const deleteButton = contentTemplate.content.querySelector("[data-accmgmt-content='delete']").querySelector("button");
      deleteButton.addEventListener('click', () => this.handleDeleteButtonOnClick(item.id));

      const statusParts = contentTemplate.content.querySelector("[data-accmgmt-content='status']");
      const active = statusParts.querySelector("[data-accmgmt-status='active']");
      const activeButton = active.querySelector("button");
      activeButton.addEventListener('click', () => this.handleStatusUpdateButtonOnClick(item.id, 0));
      const disabled = statusParts.querySelector("[data-accmgmt-status='disabled']");
      const disabledButton = disabled.querySelector("button");
      disabledButton.addEventListener('click', () => this.handleStatusUpdateButtonOnClick(item.id, 1));

      if (item.status === 1) {
        active.classList.remove("hidden");
        disabled.classList.add("hidden");
      } else if (item.status === 0) {
        active.classList.add("hidden");
        disabled.classList.remove("hidden");
      }
      // handle rendering type specify item
      this.renderViewItem(item, contentTemplate.content);
      contentContainer.appendChild(contentTemplate.content);
    });
  };
  inst.buildForm = function() {
    const modal = document.getElementById('accmgmt-modal');
    const form = modal.querySelector("form");
    form.innerHTML = "";
    this.store.dispatch(this.actions.resetChangeItem());

    const formContentTemplate = document.getElementById(`accmgmt-${this.type}-form-template`).cloneNode(true);;

    const submitButton = modal.querySelector("[data-accmgmt-form='submit']").querySelector("button");
    const submitClone = submitButton.cloneNode(true);
    submitClone.addEventListener('click', (e) => this.handleFormOnSubmit(e));
    // submitClone.disabled = !this.isFormSubmittable();
    submitButton.replaceWith(submitClone);
    // Perform type specific rendering
    this.renderFormItem(formContentTemplate.content);

    form.appendChild(formContentTemplate.content);
    handleModalOnToggleById('accmgmt-modal');  
  };
  inst.renderViewItem = function(item, content) {
    console.error("To be implemented");
    alert("To be implemented");
  };
  inst.renderFormItem = function(content) {
    console.error("To be implemented");
    alert("To be implemented");
  };
  inst.handleAddItemButtonOnClick = function() {
    this.buildForm();
  };
  inst.handleDeleteButtonOnClick = function(id) {
    let confirmation = confirm("Are you sure to delete item?");
    if (confirmation) {
      this.store.dispatch(this.actions.deleteItem(id));
    }
  };
  inst.handleStatusUpdateButtonOnClick = function(id, status) {
    let confirmation = confirm("Are you sure to update status?");
    if (confirmation) {
      this.store.dispatch(this.actions.updateItem(id, status));
    }
  };
  inst.handleFormOnSubmit = function(e) {
    e.preventDefault();
    if (!this.isFormSubmittable()) {
      return;
    }
    let confirmation = confirm("Are you sure to create item?");
    if (confirmation) {
      this.store.dispatch(this.actions.createItem());
    }
    handleModalOnToggleById('accmgmt-modal');  
  };
  inst.handleFormInputOnChange = function(name, value) {
    const labelContainer = document.querySelector(`[data-accmgmt-form='${name}']`);
    handleInputLabels(labelContainer, value);
    this.store.dispatch(this.actions.setChangeItem({[name]: value}));
  };
  inst.handleCollapseCardHeaderOnClick = handleCollapseCardHeaderOnClick;
  inst.isFormSubmittable = function() {
    // To be overwritten
    return true;
  };
  return inst; 
};
