"use strict";

import {createStore, displayActionResponse, onNavInitialize} from './common.js';
import {isValidPassword, isAlphaNumeric, handleInputLabels} from './common.js';
import {APIPrefix, getJsonRequestHeaderWithCsrf} from './common.js';
import {checkRequiredFieldInItem, checkInvalidCharacterInItem} from './common.js';
import {checkInvalidPasswordInItem} from './common.js';
import {handleViewPasswordIconOnClick} from './common.js';

const Page = () => {
  const inst = {};
  inst.buildPage = () => {
    const usernameInput = document.querySelector("[data-usermgmt-changepw='username']").querySelector("input");
    // usernameInput.addEventListener("change", (e) => inst.handleInputOnChange("username", e.target.type, e.target.value));
    const hasUserRecord = usernameInput && usernameInput.value !== null && usernameInput.value !== undefined && usernameInput.value !== '';
    if (hasUserRecord) {
      inst.handleInputOnChange("username", usernameInput.type, usernameInput.value);
    }
    const originalPwInput = document.querySelector("[data-usermgmt-changepw='originalPassword']").querySelector("input");
    originalPwInput.addEventListener("change", (e) => inst.handleInputOnChange("originalPassword", e.target.type, e.target.value));
    const viewOriginalPwIcons = document.querySelector("[data-login-form='vieworiginal']")
    const showOriginalPwIcon = viewOriginalPwIcons.querySelector("[data-form-viewpw='show']");
    const hideOriginalPwIcon = viewOriginalPwIcons.querySelector("[data-form-viewpw='hide']");
    showOriginalPwIcon.addEventListener(
      "click",
      () => handleViewPasswordIconOnClick(true, originalPwInput, showOriginalPwIcon, hideOriginalPwIcon)
    );
    hideOriginalPwIcon.addEventListener(
      "click",
      () => handleViewPasswordIconOnClick(false, originalPwInput, showOriginalPwIcon, hideOriginalPwIcon)
    );

    const newPwInput = document.querySelector("[data-usermgmt-changepw='newPassword']").querySelector("input");
    newPwInput.addEventListener("change", (e) => inst.handleInputOnChange("newPassword", e.target.type, e.target.value));
    const viewNewPwIcons = document.querySelector("[data-login-form='viewnew']")
    const showNewPwIcon = viewNewPwIcons.querySelector("[data-form-viewpw='show']");
    const hideNewPwIcon = viewNewPwIcons.querySelector("[data-form-viewpw='hide']");
    showNewPwIcon.addEventListener(
      "click", () => handleViewPasswordIconOnClick(true, newPwInput, showNewPwIcon, hideNewPwIcon));
    hideNewPwIcon.addEventListener(
      "click", () => handleViewPasswordIconOnClick(false, newPwInput, showNewPwIcon, hideNewPwIcon));

    const submitButton = document.querySelector("[data-usermgmt-changepw='submit']").querySelector("button");
    if (hasUserRecord) {
      submitButton.addEventListener("click", inst.handleSubmitButtonOnClick);
    } else {
      submitButton.disabled = true;
    }
  };
  inst.handleInputOnChange = (name, type, value) => {
    const labelContainer = document.querySelector(`[data-usermgmt-changepw='${name}']`);
    handleInputLabels(labelContainer, value, type);
    store.dispatch(actions.setChangeItem({[name]: value}));
    const submitButton = document.querySelector("[data-usermgmt-changepw='submit']").querySelector("button");
    // submitButton.disabled = !inst.isSubmitButtonActive();
  };
  inst.handleSubmitButtonOnClick = (e) => {
    e.preventDefault();
    if (!inst.isSubmitButtonActive()) {
      return;
    }
    let confirmation = confirm("Are you sure to change password?");
    if (confirmation) {
      store.dispatch(actions.changePassword());
    }
  };
  inst.isSubmitButtonActive = () => {
    const {changeItem} = store.getState();
    let isValid = checkRequiredFieldInItem(changeItem, ['username', 'originalPassword', 'newPassword']);
    if (!isAlphaNumeric(changeItem.username)) {
      alert("Username should contain number and alphabet only");
      return false;
    }
    isValid = isValid && checkInvalidPasswordInItem(changeItem, ['newPassword']);
    return isValid;
  };
  return inst;
};


// Redux architecture pieces
const actions = {
  setChangeItem: (item) => {
    return {
      type: 'SET_CHANGE_ITEM',
      payload: item,
    };
  },
  changePassword: () => {
    return {
      type: 'CHANGE_PASSWORD',
    };
  }
};

const initialState = {
  changeItem: {},
};

const changepwReducer = (state = initialState, action) => {
  switch (action.type) {
    case 'SET_CHANGE_ITEM':
      let changeItem = Object.assign(
         Object.assign({}, state.changeItem), action.payload);
      return Object.assign(Object.assign({}, state), {changeItem});

    case 'CHANGE_PASSWORD':
      changePassword(state.changeItem);
      return state;

    default:
      return state;
  }
};

const store = createStore(changepwReducer);

const changePassword = (body) => {
  fetch(`${APIPrefix}/user/change-password`, {
    method: 'PUT',
    headers: getJsonRequestHeaderWithCsrf({
      'Content-Type': 'application/json'
    }),
    body: JSON.stringify(body)
  }).then(response => {
    return response.json();
  }).then(result => {
    displayActionResponse(result);
    if (result.result === "Success") {
      window.location.replace(document.referrer);
    }
  }).catch(error => {
    console.error(error);
  });
};
const page = Page();

document.addEventListener("DOMContentLoaded", function(){
  onNavInitialize();
  page.buildPage();
});
