"use strict";

import {onNavInitialize} from './common.js';
import {store, actions} from './model/approval_model.js';
import {getBaseTabPage} from './component/tabpage.js';
import {BaseApproval} from './component/approval_component.js';
import {ApprovalRequest} from './approval_request.js';


const contents = {
  'request': ApprovalRequest(store, actions),
  'history': BaseApproval('history', store, actions),
};
const page = getBaseTabPage(store, actions, contents);

document.addEventListener("DOMContentLoaded", function(){
  onNavInitialize();
  page.initialize();
});
