"use strict";

import {onNavInitialize} from './common.js';
import {store, actions} from './model/activity_model.js';
import {History} from './activity_log.js';

const history = History(store, actions, 'history');

document.addEventListener("DOMContentLoaded", function(){
  onNavInitialize();
  // Breadcrumb
  const {tag} = store.getState()

  // Content
  const contentContainer = document.querySelector(`[data-${tag}='content']`);
  contentContainer.innerHTML = "";
  const content = document.querySelector(`[data-${tag}-content='history']`).cloneNode(true).content;
  contentContainer.appendChild(content);

  history.initialize();
});
