/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.credit_reference_platform.crp.gateway.startup;

import com.gitlab.credit_reference_platform.crp.gateway.datasource.configuration.DataSourceConfiguration;
import com.gitlab.credit_reference_platform.crp.gateway.encryption.utils.SystemEncryptionUtils;
import com.gitlab.credit_reference_platform.crp.gateway.license.CRPGatewayLicense;
import com.gitlab.vincenthung.commons.security.keystore.factory.KeyStoreFactory;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.util.Map;
import java.util.Properties;
import javax.crypto.SecretKey;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CRPStartupConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CRPStartupConfiguration.class);
    public static final String CRP_STARTUP_PROP_FILENAME = "${baseDir}/conf/crp-gateway.properties";
    private static final Exception CRP_CONFIGURATION_EXCEPTION = new Exception("The basic configurations for CRP Gateway to start are not configured properly, please execute app-configure.sh to follow the instruction to configure OR configure it manually in file conf/crp-gateway.yml.");

    public static void loadApplicationLicense() throws Exception {
        CRPGatewayLicense.loadApplicationLicense();
    }

    public static void loadStartupProperties() throws Exception {
        CRPStartupConfiguration.loadPropertiesFile((String)"${baseDir}/conf/crp-gateway.properties");
    }

    private static void loadPropertiesFile(String propFilePath) throws Exception {
        String propFilename = new StandardEnvironment().resolvePlaceholders(propFilePath);
        File file = new File(propFilename);
        if (!file.isFile()) {
            log.error(String.format("The startup properties file [%s] does not exist", Paths.get(propFilename, new String[0]).normalize().toAbsolutePath()));
            throw CRP_CONFIGURATION_EXCEPTION;
        }
        Properties properties = new Properties();
        try (FileInputStream fis = new FileInputStream(file);){
            properties.load(fis);
        }
        properties.putAll((Map<?, ?>)System.getProperties());
        System.getProperties().putAll((Map<?, ?>)properties);
        log.info(String.format("Startup properties [%s] were loaded", Paths.get(propFilename, new String[0]).normalize().toAbsolutePath()));
    }

    public static void processConfigurations() throws Exception {
        CRPStartupConfiguration.processMasterKeyStoreConfiguration(null);
        CRPStartupConfiguration.processDataSourceProperties(null);
    }

    public static void processDataSourceProperties(Properties dataSourceProperties) {
        DataSourceConfiguration dataSource;
        if (dataSourceProperties != null) {
            System.getProperties().putAll((Map<?, ?>)dataSourceProperties);
        }
        try {
            dataSource = DataSourceConfiguration.fromProperties((Properties)System.getProperties());
        }
        catch (Exception e) {
            log.warn("Failed to read DataSoruceProperties from system properties");
            return;
        }
        Properties decryptedProperties = dataSource.toDecryptedProperties();
        if (decryptedProperties != null) {
            System.getProperties().putAll((Map<?, ?>)decryptedProperties);
            log.info("Processed data source properties");
        }
    }

    public static SecretKey getMasterSecretKey(File keyStoreFile, String keyStoreType, char[] keyStorePass, String keyAlias, String keyPass) throws Exception {
        KeyStoreFactory keyStoreFactory = KeyStoreFactory.init((URL)keyStoreFile.toURI().toURL(), (char[])keyStorePass, (String)keyStoreType);
        KeyStore.SecretKeyEntry entry = keyStoreFactory.getSecretKeyEntry(keyAlias, StringUtils.hasText((String)keyPass) ? keyPass.toCharArray() : keyStorePass);
        return entry.getSecretKey();
    }

    public static void processMasterKeyStoreConfiguration(Properties keyStoreProperties) throws Exception {
        char[] password;
        String masterKeyStoreFilename;
        if (keyStoreProperties != null) {
            System.getProperties().putAll((Map<?, ?>)keyStoreProperties);
        }
        if (!StringUtils.hasText((String)(masterKeyStoreFilename = System.getProperty("crp.system.keystore.master.filename")))) {
            log.error("The master keystore filename does not be configured");
            throw CRP_CONFIGURATION_EXCEPTION;
        }
        masterKeyStoreFilename = new StandardEnvironment().resolvePlaceholders(masterKeyStoreFilename);
        String masterKeyStoreType = System.getProperty("crp.system.keystore.master.type");
        if (!StringUtils.hasText((String)masterKeyStoreType)) {
            log.error("The master keystore type does not be configured");
            throw CRP_CONFIGURATION_EXCEPTION;
        }
        String masterKeyAlias = System.getProperty("crp.system.keystore.master.key.alias");
        String masterKeyPassword = System.getProperty("crp.system.keystore.master.key.password");
        if (!StringUtils.hasText((String)masterKeyAlias)) {
            log.error("The alias of master key does not be configured");
            throw CRP_CONFIGURATION_EXCEPTION;
        }
        File masterKeyStoreFile = new File(masterKeyStoreFilename);
        if (!masterKeyStoreFile.isFile()) {
            log.error(String.format("The Master KeyStore file configured [%s] does not exist", Paths.get(masterKeyStoreFilename, new String[0]).normalize().toAbsolutePath()));
            throw CRP_CONFIGURATION_EXCEPTION;
        }
        String envPwd = System.getenv("crp.system.keystore.master.password");
        if (!StringUtils.hasText((String)envPwd)) {
            envPwd = System.getenv("CRP_MASTER_KEYSTORE_PASSWORD");
        }
        if (!StringUtils.hasText((String)envPwd)) {
            envPwd = System.getProperty("crp.system.keystore.master.password");
        }
        if (!StringUtils.hasText((String)envPwd)) {
            Console console = System.console();
            password = console.readPassword("Master KeyStore [%s] Password: ", Paths.get(masterKeyStoreFilename, new String[0]).normalize().toAbsolutePath());
        } else {
            password = envPwd.toCharArray();
        }
        SystemEncryptionUtils.secretKey = CRPStartupConfiguration.getMasterSecretKey((File)masterKeyStoreFile, (String)masterKeyStoreType, (char[])password, (String)masterKeyAlias, (String)masterKeyPassword);
        log.info("Master secret key configured");
    }
}

