/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.credit_reference_platform.crp.gateway.startup;

import com.gitlab.credit_reference_platform.crp.gateway.datasource.configuration.DataSourceConfiguration;
import com.gitlab.credit_reference_platform.crp.gateway.startup.CRPStartupConfiguration;
import java.io.Console;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Properties;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CRPApplicationConfigurer {
    public static void configureStartupProperties() throws Exception {
        Properties properties = new Properties();
        String propFilename = new StandardEnvironment().resolvePlaceholders("${baseDir}/conf/crp-gateway.properties");
        File file = new File(propFilename);
        if (file.exists() && file.isDirectory()) {
            System.out.println(String.format("The path %s cannot be a directory, please remove it and configure again", propFilename));
            return;
        }
        Properties keyStoreProperties = CRPApplicationConfigurer.configureKeyStoreProperties();
        try {
            CRPStartupConfiguration.processMasterKeyStoreConfiguration((Properties)keyStoreProperties);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The input properties for master keystore is incorrect", e);
        }
        properties.putAll((Map<?, ?>)keyStoreProperties);
        Properties dataSourceProperties = CRPApplicationConfigurer.configureDataSourceProperties();
        properties.putAll((Map<?, ?>)dataSourceProperties);
        file.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(file);
        CRPApplicationConfigurer.saveStartupProperties((Properties)properties, (FileOutputStream)fos);
    }

    private static Properties configureKeyStoreProperties() {
        Properties properties = new Properties();
        Console console = System.console();
        String defaultPath = "${baseDir}/master.p12";
        String masterKeyStorePath = console.readLine("Please input the master keystore location [%s] (Enter): ", defaultPath);
        properties.put("crp.system.keystore.master.filename", StringUtils.hasText((String)masterKeyStorePath) ? masterKeyStorePath : defaultPath);
        String defaultType = "pkcs12";
        String masterKeyStoreType = console.readLine("Please input the master keystore type [%s] (Enter): ", defaultType);
        properties.put("crp.system.keystore.master.type", StringUtils.hasText((String)masterKeyStoreType) ? masterKeyStoreType : defaultType);
        String defaultAlias = "master";
        String masterKeyAlias = console.readLine("Please input the alias of the master key [%s] (Enter): ", defaultAlias);
        properties.put("crp.system.keystore.master.key.alias", StringUtils.hasText((String)masterKeyAlias) ? masterKeyAlias : defaultAlias);
        return properties;
    }

    private static Properties configureDataSourceProperties() {
        Console console = System.console();
        String jdbcUrl = console.readLine("Please input the JDBC URL for database connection: ", new Object[0]);
        String username = console.readLine("Please input the database username for CRP Gateway: ", new Object[0]);
        char[] password = console.readPassword("Please input the database password for CRP Gateway: ", new Object[0]);
        DataSourceConfiguration dataSource = new DataSourceConfiguration(jdbcUrl, username, new String(password));
        return dataSource.toEncryptedProperties();
    }

    private static void saveStartupProperties(Properties properties, FileOutputStream fos) throws IOException {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.systemDefault());
        properties.store(fos, String.format("CRP Gateway Startup Configuration, configured at %s", formatter.format(Instant.now())));
        System.out.println("===================== Configurations Saved =====================");
    }
}

