/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.credit_reference_platform.crp.gateway.ssl.customizer;

import com.gitlab.credit_reference_platform.crp.gateway.acctmgmt.enum_type.SecretSubType;
import com.gitlab.credit_reference_platform.crp.gateway.acctmgmt.service.ICertificateSecretService;
import com.gitlab.credit_reference_platform.crp.gateway.certificate.CertificateGeneratorBuilder;
import com.gitlab.credit_reference_platform.crp.gateway.certificate.CertificateGeneratorException;
import com.gitlab.credit_reference_platform.crp.gateway.exception.ServiceException;
import com.gitlab.vincenthung.commons.security.keystore.factory.KeyStoreFactory;
import com.gitlab.vincenthung.commons.security.keystore.factory.KeyStoreFactoryException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import org.apache.catalina.connector.Connector;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.http11.AbstractHttp11JsseProtocol;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class CRPGatewayConnectorCustomizer
implements TomcatConnectorCustomizer {
    @Autowired
    private ICertificateSecretService certificateSecretService;
    @Value(value="${server.port:443}")
    private int port;

    public void customize(Connector connector) {
        ProtocolHandler handler = connector.getProtocolHandler();
        Assert.state((boolean)(handler instanceof AbstractHttp11JsseProtocol), (String)"To use SSL, the connector's protocol handler must be an AbstractHttp11JsseProtocol subclass");
        AbstractHttp11JsseProtocol protocol = (AbstractHttp11JsseProtocol)handler;
        try {
            this.updateSSLHostConfig(protocol);
        }
        catch (ServiceException e) {
            throw new IllegalStateException("Failed to obtain the CRP certificates / Gateway private key from database", e);
        }
        catch (KeyStoreFactoryException e) {
            throw new IllegalStateException("Failed to load CRP certificates / Gateway private key to KeyStoreFactory", e);
        }
        catch (CertificateGeneratorException e) {
            throw new IllegalStateException("Failed to generate Gateway private key pair", e);
        }
        connector.setScheme("https");
        connector.setSecure(true);
        connector.setPort(this.port);
        protocol.setSSLEnabled(true);
    }

    private void updateSSLHostConfig(AbstractHttp11JsseProtocol<?> protocol) throws ServiceException, KeyStoreFactoryException, CertificateGeneratorException {
        SSLHostConfig[] configs = protocol.findSslHostConfigs();
        SSLHostConfig config = null;
        if (configs.length == 0) {
            config = new SSLHostConfig();
            config.setHostName(protocol.getDefaultSSLHostConfigName());
            protocol.addSslHostConfig(config);
        } else {
            config = configs[0];
        }
        SSLHostConfigCertificate certificate = this.getSSLHostConfigCertificate(config, SSLHostConfigCertificate.Type.RSA);
        config.addCertificate(certificate);
        config.setSslProtocol("TLSv1.2");
        KeyStore trustStore = this.getTrustStore();
        config.setTrustStore(trustStore);
    }

    private SSLHostConfigCertificate getSSLHostConfigCertificate(SSLHostConfig config, SSLHostConfigCertificate.Type type) throws ServiceException, KeyStoreFactoryException, CertificateGeneratorException {
        List privateKeyEntries = this.certificateSecretService.getActivePrivateKeyEntries(SecretSubType.GATEWAY_SERVER_CERTIFICATE);
        KeyStore.PrivateKeyEntry privateKeyEntry = null;
        if (privateKeyEntries != null && !privateKeyEntries.isEmpty()) {
            privateKeyEntry = (KeyStore.PrivateKeyEntry)privateKeyEntries.getFirst();
        }
        if (privateKeyEntry == null) {
            privateKeyEntry = new CertificateGeneratorBuilder().build().generateSelfSignedCertificate();
        }
        String keyAlias = "crp-gateway";
        String dummyKeyPass = "dummy";
        KeyStoreFactory factory = KeyStoreFactory.init(null, null, null);
        factory.addPrivateKeyWithCertificate(privateKeyEntry.getPrivateKey(), privateKeyEntry.getCertificateChain(), keyAlias, dummyKeyPass.toCharArray(), true);
        SSLHostConfigCertificate certificate = new SSLHostConfigCertificate(config, type);
        certificate.setCertificateKeystore(factory.getKeyStore());
        certificate.setCertificateKeyAlias(keyAlias);
        certificate.setCertificateKeyPassword(dummyKeyPass);
        return certificate;
    }

    private KeyStore getTrustStore() throws ServiceException, KeyStoreFactoryException {
        List certificates = this.certificateSecretService.getActiveCertificates(SecretSubType.CRP_SERVER_CERTIFICATE);
        if (certificates != null && !certificates.isEmpty()) {
            KeyStoreFactory factory = KeyStoreFactory.init(null, null, null);
            for (int index = 0; index < certificates.size(); ++index) {
                X509Certificate certificate = (X509Certificate)certificates.get(index);
                factory.addTrustedCertificate((Certificate)certificate, "crp" + index, true);
            }
            return factory.getKeyStore();
        }
        return null;
    }
}

