/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.credit_reference_platform.crp.gateway.security.configuration;

import com.gitlab.credit_reference_platform.crp.gateway.constants.GatewayURL;
import com.gitlab.credit_reference_platform.crp.gateway.customize.cub.security.configuration.SsoAuthenticationFailureHandler;
import com.gitlab.credit_reference_platform.crp.gateway.customize.cub.security.configuration.SsoAuthenticationProvider;
import com.gitlab.credit_reference_platform.crp.gateway.customize.cub.security.configuration.SsoLoginConfigurer;
import com.gitlab.credit_reference_platform.crp.gateway.encryption.utils.PasswordEncryptionUtils;
import com.gitlab.credit_reference_platform.crp.gateway.ldap.configuration.LdapConfigurationDelegate;
import com.gitlab.credit_reference_platform.crp.gateway.oauth2.service.IOAuth2Service;
import com.gitlab.credit_reference_platform.crp.gateway.portal.constant.PortalConstants;
import com.gitlab.credit_reference_platform.crp.gateway.security.authority.CRPGatewayGrantedAuthorities;
import com.gitlab.credit_reference_platform.crp.gateway.security.authority.CRPGatewayRoles;
import com.gitlab.credit_reference_platform.crp.gateway.security.configuration.ApiKeyAuthFilter;
import com.gitlab.credit_reference_platform.crp.gateway.security.configuration.LicenseFilter;
import com.gitlab.credit_reference_platform.crp.gateway.security.configuration.OAuth2AuthFilter;
import com.gitlab.credit_reference_platform.crp.gateway.security.configuration.PortalAccessFilter;
import com.gitlab.credit_reference_platform.crp.gateway.security.configuration.PortalAuthenticationFailureHandler;
import com.gitlab.credit_reference_platform.crp.gateway.security.configuration.PortalAuthenticationSuccessHandler;
import com.gitlab.credit_reference_platform.crp.gateway.security.configuration.PortalCsrfRequestMatcher;
import com.gitlab.credit_reference_platform.crp.gateway.security.configuration.PortalLogoutSuccessHandler;
import jakarta.annotation.Resource;
import jakarta.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.StringUtils;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
@DependsOn(value={"crpPropertiesService"})
public class SecurityConfiguration {
    @Autowired
    private IOAuth2Service oAuth2Service;
    @Resource
    private UserDetailsService userDetailsService;
    @Autowired
    private PortalAuthenticationSuccessHandler portalAuthenticationSuccessHandler;
    @Autowired
    private PortalAuthenticationFailureHandler portalAuthenticationFailureHandler;
    @Autowired
    private SsoAuthenticationFailureHandler ssoAuthenticationFailureHandler;
    @Autowired
    private PortalLogoutSuccessHandler portalLogoutSuccessHandler;
    @Autowired
    private LdapConfigurationDelegate ldapConfigurationDelegate;
    @Autowired(required=false)
    private SsoAuthenticationProvider ssoAuthenticationProvider;
    @Value(value="${crp.gateway.integration.api_key:}")
    private String apiKey;
    @Value(value="${crp.gateway.integration.whitelisted_subnets:}")
    private String whitelistedIpSubnets;
    @Value(value="${crp.gateway.customize.cub.sso.enabled:false}")
    private boolean cubSsoEnabled;
    @Value(value="${crp.gateway.customize.cub.sso.auth-url:}")
    private String cubSsoAuthUrl;

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        ApiKeyAuthFilter apiKeyAuthFilter;
        PortalAccessFilter portalAccessFilter = this.portalAccessFilter();
        if (portalAccessFilter != null) {
            http.addFilterBefore((Filter)portalAccessFilter, UsernamePasswordAuthenticationFilter.class);
        }
        if ((apiKeyAuthFilter = this.apiKeyAuthFilter()) != null) {
            http.addFilterBefore((Filter)apiKeyAuthFilter, UsernamePasswordAuthenticationFilter.class);
        }
        LicenseFilter licenseFilter = this.licenseFilter();
        http.addFilterBefore((Filter)licenseFilter, UsernamePasswordAuthenticationFilter.class);
        OAuth2AuthFilter oAuth2AuthFilter = new OAuth2AuthFilter(this.oAuth2Service);
        http.addFilterBefore((Filter)oAuth2AuthFilter, UsernamePasswordAuthenticationFilter.class);
        http.csrf(csrf -> csrf.requireCsrfProtectionMatcher((RequestMatcher)new PortalCsrfRequestMatcher())).authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.requestMatchers(new String[]{"/actuator/health/**"})).permitAll().requestMatchers(new String[]{"/change-password", "/api/v1/user/change-password"})).permitAll().requestMatchers(new String[]{"/license", "/api/v1/license"})).permitAll().requestMatchers(new String[]{"/api/system-restart"})).hasAnyAuthority(new String[]{CRPGatewayGrantedAuthorities.API.getAuthority(), CRPGatewayRoles.SYSTEM_SERVICES.getAuthorityName()}).requestMatchers(new String[]{"/access-token"})).permitAll().requestMatchers(GatewayURL.CRP_URLS)).hasAuthority(CRPGatewayGrantedAuthorities.CRP.getAuthority()).requestMatchers(GatewayURL.RESOURCES_URLS)).permitAll().requestMatchers(new String[]{"/error"})).permitAll()).logout(logout -> logout.logoutSuccessHandler((LogoutSuccessHandler)this.portalLogoutSuccessHandler));
        if (this.cubSsoEnabled && StringUtils.hasText((String)this.cubSsoAuthUrl)) {
            SsoLoginConfigurer ssoLoginConfigurer = new SsoLoginConfigurer();
            http.with((SecurityConfigurerAdapter)ssoLoginConfigurer, configurer -> ((SsoLoginConfigurer)((SsoLoginConfigurer)configurer.loginProcessingUrl("/login")).successHandler((AuthenticationSuccessHandler)this.portalAuthenticationSuccessHandler)).failureHandler((AuthenticationFailureHandler)this.ssoAuthenticationFailureHandler));
        } else {
            http.formLogin(form -> ((FormLoginConfigurer)form.loginPage("/login").successHandler((AuthenticationSuccessHandler)this.portalAuthenticationSuccessHandler)).failureHandler((AuthenticationFailureHandler)this.portalAuthenticationFailureHandler)).authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.requestMatchers(PortalConstants.getPermitAllUrls())).permitAll());
        }
        http.authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.requestMatchers(new String[]{"/", "/portal/**"})).hasAuthority(CRPGatewayGrantedAuthorities.USER.getAuthority()).requestMatchers(new String[]{"/api/**"})).hasAnyAuthority(new String[]{CRPGatewayGrantedAuthorities.USER.getAuthority(), CRPGatewayGrantedAuthorities.API.getAuthority()}).anyRequest()).denyAll());
        return (SecurityFilterChain)http.build();
    }

    @Autowired
    public void configure(AuthenticationManagerBuilder auth) throws Exception {
        if (this.cubSsoEnabled && StringUtils.hasText((String)this.cubSsoAuthUrl)) {
            auth.authenticationProvider((AuthenticationProvider)this.ssoAuthenticationProvider);
            return;
        }
        AuthenticationProvider authenticationProvider = this.ldapConfigurationDelegate.getLdapAuthenticationProvider();
        if (authenticationProvider != null) {
            auth.authenticationProvider(authenticationProvider);
            return;
        }
        auth.userDetailsService(this.userDetailsService).passwordEncoder(PasswordEncryptionUtils.getPasswordEncoder());
    }

    private ApiKeyAuthFilter apiKeyAuthFilter() {
        if (StringUtils.hasText((String)this.apiKey)) {
            return new ApiKeyAuthFilter(this.apiKey);
        }
        return null;
    }

    private PortalAccessFilter portalAccessFilter() {
        if (StringUtils.hasText((String)this.whitelistedIpSubnets)) {
            return new PortalAccessFilter(this.whitelistedIpSubnets.split(","));
        }
        return null;
    }

    private LicenseFilter licenseFilter() {
        return new LicenseFilter();
    }
}

