/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.credit_reference_platform.crp.gateway.security.configuration;

import com.gitlab.credit_reference_platform.crp.gateway.constants.GatewayURL;
import jakarta.servlet.http.HttpServletRequest;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.StringUtils;

public class PortalCsrfRequestMatcher
implements RequestMatcher {
    private HashSet<String> allowedMethods = new HashSet<String>(Arrays.asList("GET", "HEAD", "TRACE", "OPTIONS"));

    private List<AntPathRequestMatcher> getDisableCsrfMatchers() {
        ArrayList<AntPathRequestMatcher> matchers = new ArrayList<AntPathRequestMatcher>();
        matchers.add(new AntPathRequestMatcher("/access-token"));
        matchers.add(new AntPathRequestMatcher("/api/system-restart"));
        for (String url : GatewayURL.CRP_URLS) {
            matchers.add(new AntPathRequestMatcher(url));
        }
        return matchers;
    }

    public boolean matches(HttpServletRequest request) {
        if (this.allowedMethods.contains(request.getMethod())) {
            return false;
        }
        if (StringUtils.hasText((String)request.getHeader("apiKey"))) {
            return false;
        }
        for (AntPathRequestMatcher rm : this.getDisableCsrfMatchers()) {
            if (!rm.matches(request)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return MessageFormat.format("CsrfNotRequired: methods ({0}) and pattern ({1})", "/access-token", GatewayURL.CRP_URLS);
    }
}

