/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.credit_reference_platform.crp.gateway.security.configuration;

import com.gitlab.credit_reference_platform.crp.gateway.security.user.PortalUserDetails;
import com.gitlab.credit_reference_platform.crp.gateway.system.activity.dto.ActivityDTO;
import com.gitlab.credit_reference_platform.crp.gateway.system.activity.enum_type.ActivityActionType;
import com.gitlab.credit_reference_platform.crp.gateway.system.activity.enum_type.ActivityCategory;
import com.gitlab.credit_reference_platform.crp.gateway.system.activity.enum_type.ActivityStatus;
import com.gitlab.credit_reference_platform.crp.gateway.system.activity.enum_type.ActivityType;
import com.gitlab.credit_reference_platform.crp.gateway.system.activity.service.IActivityService;
import com.gitlab.credit_reference_platform.crp.gateway.usermgmt.service.IUserService;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class PortalAuthenticationSuccessHandler
extends SavedRequestAwareAuthenticationSuccessHandler {
    @Autowired
    private IUserService userService;
    @Autowired
    private IActivityService activityService;

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        Object principal = authentication.getPrincipal();
        if (principal instanceof PortalUserDetails) {
            PortalUserDetails userDetails = (PortalUserDetails)principal;
            String username = userDetails.getUsername();
            this.userService.resetLoginFailedCount(username);
            if (StringUtils.hasText((String)username)) {
                this.insertActivityRecord(username);
            }
        }
        super.onAuthenticationSuccess(request, response, authentication);
    }

    protected void insertActivityRecord(String username) {
        ActivityDTO activity = new ActivityDTO();
        activity.setCategory(ActivityCategory.SYSTEM);
        activity.setType(ActivityType.USER_LOGIN);
        activity.setActionType(ActivityActionType.ACTION);
        activity.setActivityUsername(username);
        activity.setActivityTime(Instant.now());
        activity.setActivityMessage("Logged in");
        activity.setStatus(ActivityStatus.SUCCESS);
        this.activityService.insertActivityRecord(activity);
    }
}

