/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.credit_reference_platform.crp.gateway.security.configuration;

import com.gitlab.credit_reference_platform.crp.gateway.constants.GatewayURL;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.util.matcher.IpAddressMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class PortalAccessFilter
implements Filter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PortalAccessFilter.class);
    private final List<IpAddressMatcher> allowedIpMatchers;
    private static final RequestMatcher EXCLUDED_REQUEST_MATCHER = GatewayURL.AntMatcherBuilder.builder().addAntPath("/access-token").addAntPaths(GatewayURL.CRP_URLS).addAntPath("/error").build();

    public PortalAccessFilter(String ... allowedIpSubnets) {
        this(Arrays.asList(allowedIpSubnets));
    }

    public PortalAccessFilter(List<String> allowedIpSubnets) {
        this.allowedIpMatchers = allowedIpSubnets.stream().map(ip -> new IpAddressMatcher(ip)).collect(Collectors.toList());
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest;
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse && !EXCLUDED_REQUEST_MATCHER.matches(httpRequest = (HttpServletRequest)request)) {
            String requestPath = httpRequest.getRequestURI();
            String remoteAddr = request.getRemoteAddr();
            if (log.isTraceEnabled()) {
                log.trace("Attempt Portal Access [{}] from [{}]", (Object)requestPath, (Object)remoteAddr);
            }
            if (!this.isAllowedIpAddress(request.getRemoteAddr())) {
                log.debug("Declined Portal Access [{}] from [{}]", (Object)requestPath, (Object)remoteAddr);
                ((HttpServletResponse)response).sendError(403);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    private boolean isAllowedIpAddress(String remoteIpAddr) {
        for (IpAddressMatcher ipMatcher : this.allowedIpMatchers) {
            if (!ipMatcher.matches(remoteIpAddr)) continue;
            return true;
        }
        return false;
    }
}

