/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.credit_reference_platform.crp.gateway.customize.cub.service;

import com.gitlab.credit_reference_platform.crp.gateway.customize.cub.client.SsoClient;
import com.gitlab.credit_reference_platform.crp.gateway.customize.cub.model.SsoTokenVerificationRequest;
import com.gitlab.credit_reference_platform.crp.gateway.customize.cub.model.SsoTokenVerificationResponse;
import com.gitlab.credit_reference_platform.crp.gateway.customize.cub.service.ISsoTokenService;
import com.gitlab.credit_reference_platform.crp.gateway.exception.ServiceException;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SsoTokenServiceImpl
implements ISsoTokenService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SsoTokenServiceImpl.class);
    @Autowired
    private final SsoClient ssoClient;

    public SsoTokenServiceImpl(SsoClient ssoClient) {
        this.ssoClient = ssoClient;
    }

    public boolean verifyToken(String employeeId, String appName, String token, String ip) throws ServiceException {
        SsoTokenVerificationResponse response;
        SsoTokenVerificationRequest request = SsoTokenVerificationRequest.builder().employeeId(employeeId).appName(appName).token(token).ip(ip).build();
        try {
            response = this.ssoClient.verifyToken(request);
        }
        catch (Exception e) {
            log.debug("SSO token service error: " + e.getMessage());
            return false;
        }
        return Objects.equals(response.getReturnCode(), "0");
    }
}

