/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.credit_reference_platform.crp.gateway.customize.cub.security.configuration;

import com.gitlab.credit_reference_platform.crp.gateway.customize.cub.security.configuration.SsoAuthenticationToken;
import com.gitlab.credit_reference_platform.crp.gateway.customize.cub.service.ISsoTokenService;
import com.gitlab.credit_reference_platform.crp.gateway.exception.ServiceException;
import com.gitlab.credit_reference_platform.crp.gateway.security.user.service.PortalUserService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;

@Component
public class SsoAuthenticationProvider
implements AuthenticationProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SsoAuthenticationProvider.class);
    @Autowired
    private ISsoTokenService ssoTokenService;
    @Autowired
    private PortalUserService userService;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        boolean isTokenValid;
        UserDetails userDetails;
        SsoAuthenticationToken authRequest = (SsoAuthenticationToken)authentication;
        String originalEmployeeId = authRequest.getOriginalEmployeeId();
        String employeeId = authRequest.getEmployeeId();
        String ssoToken = authRequest.getSsoToken();
        String ip = authRequest.getIp();
        String appName = authRequest.getAppName();
        try {
            userDetails = this.userService.loadUserByUsername(employeeId);
        }
        catch (UsernameNotFoundException e) {
            log.warn("Employee ID [{}] not found in database", (Object)employeeId);
            throw e;
        }
        try {
            isTokenValid = this.ssoTokenService.verifyToken(originalEmployeeId, appName, ssoToken, ip);
        }
        catch (ServiceException e) {
            log.error("Failed to connect to SSO service", (Throwable)e);
            throw new InternalAuthenticationServiceException("Failed to connect to SSO service", (Throwable)e);
        }
        if (!isTokenValid) {
            throw new BadCredentialsException("Credential not valid");
        }
        return new SsoAuthenticationToken(userDetails, originalEmployeeId, employeeId, ssoToken, ip, appName, userDetails.getAuthorities());
    }

    public boolean supports(Class<?> authentication) {
        return SsoAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

