"use strict";

import {onNavInitialize} from './common.js';
import {store, actions} from './model/pmds_model.js';
import {getBaseTabPage} from './component/tabpage.js';
import {History as SubmissionHistory, Submission} from './data_submission.js';
import {History as EnquiryHistory, Enquiry} from './credit_report.js';


const contents = {
  subhistory: SubmissionHistory(store, actions, 'subhistory'),
  submission: Submission(store, actions),
  enqhistory: EnquiryHistory(store, actions, 'enqhistory'),
  enquiry: Enquiry(store, actions),
};
const page = getBaseTabPage(store, actions, contents);

document.addEventListener("DOMContentLoaded", function(){
  onNavInitialize();
  page.initialize();
});
