"use strict";

import {
  createStore,
  convertUrlQueryParams,
  displayActionResponse,
} from "../common.js";
import { APIPrefix, getJsonRequestHeaderWithCsrf } from "../common.js";

// Redux architecture pieces
export const actions = {
  uploadLicense: () => {
    // Get items from fetch
    return {
      type: "UPLOAD_LICENSE",
    };
  },
  uploadSuccess: () => {
    // To be called by getItems callback
    return {
      type: "UPLOAD_SUCCESS",
    };
  },
  uploadFail: () => {
    return {
      type: "UPLOAD_FAIL",
    };
  },
  setLicense: (license) => {
    return {
      type: "SET_LICENSE",
      payload: license,
    };
  },
  reset: () => {
    return {
      type: "RESET",
    };
  },
};

const initialState = {
  license: null,
};

const licenseReducer = (state = initialState, action) => {
  switch (action.type) {
    case actions.uploadLicense().type:
      // Upload license
      uploadLicense(state.license);
      return state;
    case actions.uploadSuccess().type:
      // Handle successful upload
      return Object.assign(Object.assign({}, state), {
        license: initialState.license,
      });
    case actions.uploadFail().type:
      // Let page to subscribe
      return state;
    case actions.setLicense().type:
      // Set license
      return Object.assign(Object.assign({}, state), {
        license: action.payload,
      });
    case actions.reset().type:
      // Reset state
      return Object.assign({}, initialState);
    default:
      return state;
  }
};

export const store = createStore(licenseReducer);

const uploadLicense = (license) => {
  let body = new FormData();
  body.append("license", license);
  fetch(`${APIPrefix}/license`, {
    method: "POST",
    headers: getJsonRequestHeaderWithCsrf(),
    body: body,
  })
    .then((response) => {
      if (response.redirected) {
        window.location.href = response.url;
      } else {
        return response.json();
      }
    })
    .then((result) => {
      displayActionResponse(result);
      if (result.result === "Success") {
        store.dispatch(actions.uploadSuccess());
      } else {
        store.dispatch(actions.uploadFail());
      }
    })
    .catch((error) => {
      console.error(error);
      store.dispatch(actions.uploadFail());
    });
};
