"use strict";

import {createStore, displayActionResponse} from '../common.js';
import {APIPrefix, getJsonRequestHeaderWithCsrf, convertUrlQueryParams} from '../common.js';
import {handleDownloadResponse} from '../common.js';

// Redux architecture pieces
export const actions = {
  // Actions for Data submission common
  setFormtype: (formtype) => {
    return {
      type: 'SET_FORMTYPE',
      payload: formtype,
    };
  },
  // Actions for Submission Form
  setUploadItem: (item) => {
    return {
      type: 'SET_UPLOAD_ITEM',
      payload: item
    };
  },
  resetUploadItem: () => {
    return {
      type: 'RESET_UPLOAD_ITEM',
    };
  },
  createUploadItem: (type) => {
    return {
      type: 'CREATE_UPLOAD_ITEM',
      payload: type
    };
  },
  setDetail: (detail) => {
    return {
      type: 'SET_DETAIL',
      payload: detail
    };
  },
  setDetailLoading: (isLoading) => {
    return {
      type: 'SET_DETAIL_LOADING',
      payload: isLoading,
    };
  },
};

const initialState = {
  tag: 'filemgmt',
  tab: null,
  form: null,
  formtype: null,
  uploadItem: {},
  detail: null,
  detailLoading: false,
};

const fileManagementReducer = (state = initialState, action) => {
  let reduce, idType;
  switch (action.type) {
    case 'SET_FORMTYPE':
      reduce = (state, action) => {
        return Object.assign(Object.assign({}, state), {
          form: action.payload,
          formtype: action.payload,
          uploadItem : {},
        });
      };
      return reduce(state, action);

    case 'SET_DETAIL':
      reduce = (state, action) => {
        return Object.assign(Object.assign({}, state), {
          detail: action.payload,
        });
      };
      return reduce(state, action);

    case 'SET_UPLOAD_ITEM':
      reduce = (state, action) => {
        const uploadItem = Object.assign({}, state.uploadItem);
        return Object.assign(Object.assign({}, state), {
          uploadItem: Object.assign(uploadItem, action.payload),
        });
      };
      return reduce(state, action);

    case 'RESET_UPLOAD_ITEM':
      reduce = (state, action) => {
        return Object.assign(Object.assign({}, state), {uploadItem: {}});
      };
      return reduce(state, action);

    case 'CREATE_UPLOAD_ITEM':
      reduce = (state, action) => {
        submitFileManagementForm(action.payload, state.uploadItem);
        return store.getState();
      }
      return reduce(state, action);

    default:
      return state;
  }
};

export const store = createStore(fileManagementReducer);

const FullRequestTypeMap = {
  symkeyenq: "symmetric-key-enquiry",
  lostkeyenq: "lost-symmetric-key-enquiry",
  cplist: "cp-listing-request",
  cralist: "cra-listing-request",
  enccertenq: "encryption-certificate-enquiry",
  certupload: "certificate-upload-request",
  ppcertrevo: "certificate-revoke-request",
  csecrenew: "client-secret-renewal-notification",
  csecamend: "client-secret-amendment-request",
  msgskeyreq: "message-signing-key-request",
  hmsgenq: "historical-message-enquiry",
  hmsgresend: "historical-message-resend-request",
  // miscbusnoti: MiscellaneousBusinessNotificationRequest(store, actions),
  rptenq: "report-enquiry",
};

const submitFileManagementForm = (reqType, uploadItem) => {
  const fullReqType = FullRequestTypeMap[reqType];
  // Generic append body without validation
  let body, headers;
  if (reqType ===  "certupload" || reqType === "ppcertrevo") {
    headers = getJsonRequestHeaderWithCsrf();
    body = new FormData();
    Object.keys(uploadItem).forEach(k => {
      body.append(k, uploadItem[k]);

    });
  } else {
    headers = getJsonRequestHeaderWithCsrf({
      'Content-Type': 'application/json'
    })
    body = JSON.stringify(Object.assign({}, uploadItem));
  }
  fetch(`${APIPrefix}/crp-service/file-management/${fullReqType}`, {
    method: 'POST',
    headers: headers,
    body: body,
  }).then(response => {
    if (response.redirected) {
      window.location.href = response.url;
    } else {
      return response.json();
    }
  }).then(result => {
    console.log(result)
    displayActionResponse(result);

    if (result.result === "Success") {
      store.dispatch(actions.resetUploadItem());
      store.dispatch(actions.setDetail(result.data ? result.data : '{"message": "response not available"}'));
    }
  }).catch(error => {
    console.error(error);
  });
};
