"use strict";

import {
  b64ToBlob,
  createStore,
  displayActionResponse,
  downloadBlob,
} from "../common.js";
import { APIPrefix, getJsonRequestHeaderWithCsrf } from "../common.js";

// Redux architecture pieces
export const actions = {
  setEncryptedData: (data) => {
    return {
      type: "SET_ENCRYPTED_DATA",
      payload: data,
    };
  },
  setEncryptedSymmetricKey: (data) => {
    return {
      type: "SET_ENCRYPTED_SYMMETRIC_KEY",
      payload: data,
    };
  },
  getDecryptedData: () => {
    return {
      type: "GET_DECRYPTED_DATA",
    };
  },
  downloadDecryptedData: () => {
    return {
      type: "DOWNLOAD_DECRYPTED_DATA",
    };
  },
  setDecryptedData: (data) => {
    return {
      type: "SET_DECRYPTED_DATA",
      payload: data,
    };
  },
};

const initialState = {
  encryptedData: "",
  encryptedSymmetricKey: "",
  decryptedData: "",
};

const accmgmtDecryptionReducer = (state = initialState, action) => {
  switch (action.type) {
    case "GET_DECRYPTED_DATA":
      postDecryption(state.encryptedData, state.encryptedSymmetricKey);
      // testPostDecryption(state.encryptedData, state.encryptedSymmetricKey);
      return state;

    case "SET_DECRYPTED_DATA":
      // Set items & initialize page + currentPageItems
      return Object.assign(Object.assign({}, state), {
        decryptedData: action.payload,
      });

    case "DOWNLOAD_DECRYPTED_DATA":
      // Set items & initialize page + currentPageItems
      const blob = b64ToBlob(state.decryptedData);
      downloadBlob(blob, "file");
      return state;

    case "SET_ENCRYPTED_DATA":
      return Object.assign(Object.assign({}, state), {
        encryptedData: action.payload,
      });

    case "SET_ENCRYPTED_SYMMETRIC_KEY":
      return Object.assign(Object.assign({}, state), {
        encryptedSymmetricKey: action.payload,
      });

    default:
      return state;
  }
};

export const store = createStore(accmgmtDecryptionReducer);

const testPostDecryption = (encryptedData, encryptedSymmetricKey) => {
  console.log(
    "postDecryption called with encryptedData:",
    encryptedData,
    "and encryptedSymmetricKey:",
    encryptedSymmetricKey
  );
  setTimeout(() => {
    store.dispatch(
      actions.setDecryptedData(
        "LS0gVE8gQkUgTU9ESUZJRUQKKysgV2hpY2ggbnBtIC9ub2RlanMgdmVyc2lvbiBmb3IgcHJlLWNvbXBsaWUKKysgQ2hhbmdlIHRoZSBpbnN0cnVjdGlvbiBvbiBob3cgdG8gcHJlLWNvbXBsaWUKCkhvdyB0byBydW46CgoxLiBBZGQgVGFpbHdpbmRjc3MgKyBwb3N0Y3NzICsgYXV0b3ByZWZpeGVyIGF0IHRoZSBmaXJzdCB0aW1lICgyMDI1LTA1KQpucG0gaW5pdCAteQpucG0gaSAtRCB0YWlsd2luZGNzc0BsYXRlc3QgQHRhaWx3aW5kL3Bvc3Rjc3NAbGF0ZXN0IHBvc3Rjc3NAbGF0ZXN0IGF1dG9wcmVmaXhlckBsYXRlc3QgcG9zdGNzcy1jbGkKbnB4IHRhaWx3aW5kY3NzIGluaXQgLXAKCjIuIFVwZGF0ZSBwb3N0Y3NzIGNvbmZpZwptb2R1bGUuZXhwb3J0cyA9IHsKICBwbHVnaW5zOiB7CiAgICAiQHRhaWx3aW5kY3NzL3Bvc3Rjc3MiOiB7fSwKICAgIGF1dG9wcmVmaXhlcjoge30sCiAgfSwKfQoKMy4gUnVuIHRoZXNlIGV2ZXJ5dGltZQptdm4gY2xlYW4KbnBtIHJ1biBidWlsZDpwb3N0Y3NzCi4vbXZudyBzcHJpbmctYm9vdDpydW4gICgyMDI1LTA1OiBOb3Qgd29ya2luZyBhbnltb3JlKQo="
      )
    );
  }, 500);
};

const postDecryption = (encryptedData, encryptedSymmetricKey) => {
  const body = {
    encryptedData,
    encryptedSymmetricKey,
  }
  fetch(`${APIPrefix}/secret/manual-decrypt`, {
    method: "POST",
    headers: getJsonRequestHeaderWithCsrf({
      'Content-Type': 'application/json'
    }),
    body: JSON.stringify(body),
  })
    .then((response) => {
      if (response.redirected) {
        window.location.href = response.url;
      } else {
        return response.json();
      }
    })
    .then((result) => {
      if (result.result === "Success") {
        store.dispatch(
          actions.setDecryptedData(result.data.encodedDecryptedData)
        );
      } else {
        store.dispatch(
          actions.setDecryptedData("")
        );
        displayActionResponse(result);
      }
    })
    .catch((error) => {
      console.error(error);
    });
};
