"use strict";

import {onNavInitialize} from './common.js';
import {store, actions} from './model/datasub_model.js';
import {History, Submission, Amendment, Initload} from './data_submission.js';
import {getBaseTabPage} from './component/tabpage.js';


const contents = {
  history: History(store, actions),
  submission: Submission(store, actions),
  amendment: Amendment(store, actions),
  initload: Initload(store, actions),
};
const page = getBaseTabPage(store, actions, contents);

document.addEventListener("DOMContentLoaded", function(){
  onNavInitialize();
  page.initialize();
});
