"use strict";

import {handleInputLabels, handleModalOnToggleById} from '../common.js';
import {renderDisplayTableScrollButton} from '../common.js';
import {exportFullRecordCSV} from './history_export.js';

export const Usermgmt = (store, actions) => {
  const inst = {};
  inst.store = store;
  inst.actions = actions;
  inst.isViewing = () => {
    const modal = document.getElementById("usermgmt-modal");
    return !modal.classList.contains("hidden");
  };
  // inst.store.subscribe((action) => {
  //   if (action.type === 'SET_CHANGE_ITEM') {
  //     const addItemButton = document.querySelector("[data-usermgmt-form='additem']")?.querySelector("button");
  //     if (addItemButton) {
  //       addItemButton.disabled = !inst.isAddItemButtonActive();
  //     }
  //     const updateItemButton = document.querySelector("[data-usermgmt-form='updateitem']")?.querySelector("button");
  //     if (updateItemButton) {
  //       updateItemButton.disabled = !inst.isUpdateItemButtonActive();
  //     }
  //   } else if (action.type === 'SET_QUERY' || action.type === 'CLEAR_QUERY') {
  //     const searchButton = document.getElementById("usermgmt-query-search");
  //     if (searchButton) {
  //       searchButton.disabled = !inst.isSearchButtonActive();
  //     }
  //   }
  // });

  inst.buildUsermgmtLayout = () => {
    // Set buttons
    const searchButton = document.getElementById("usermgmt-query-search");
    searchButton.addEventListener('click', () => inst.handleSearchButtonOnClick());
    // if (searchButton) {
    //   searchButton.disabled = !inst.isSearchButtonActive();
    // }
    const clearButton = document.getElementById("usermgmt-query-clear");
    clearButton.addEventListener('click', () => inst.handleClearButtonOnClick());
    const addButton = document.getElementById("usermgmt-add-btn");
    addButton.addEventListener('click', () => inst.handleAddButtonOnClick());
    const exportButton = document.getElementById("usermgmt-export-btn");
    exportButton.addEventListener('click', () => inst.handleExportButtonOnClick());

    inst.buildUsermgmtQuery();
    inst.clearUsermgmtQuery()
  };
  inst.clearUsermgmtQuery = () => {
    const form = document.getElementById("usermgmt-query-form");
    const inputs = form.querySelectorAll("input");
    inputs.forEach(element => {
      element.value = "";
    });
  };
  inst.buildUsermgmtQuery = () => {
    // Set event for query param
    const form = document.getElementById("usermgmt-query-form");
    const inputs = form.querySelectorAll("input");
    inputs.forEach(element => {
      element.addEventListener('input', (e) => inst.handleQueryInputOnChange(element.name, e.target.value));
    });
  };

  inst.buildUsermgmtTable = (items) => {
    // Build table
    const container = document.getElementById("usermgmt-table")
    const tbody = container.getElementsByTagName("tbody")[0];
    tbody.innerHTML = "";
    items.forEach(itm => {
      const rowTemplate = document.getElementById("usermgmt-table-row-template").cloneNode(true);
      const viewButtonTemplate = document.getElementById("usermgmt-viewbutton-template").cloneNode(true);
      const viewButton = viewButtonTemplate.content.firstElementChild;
      viewButton.addEventListener('click', () => inst.handleViewButtonOnClick(itm));
      const row = rowTemplate.content.firstElementChild;
      const cols = row.children;
      inst.fillUsermgmtTableRow(cols, itm, viewButton);
      tbody.appendChild(row);
    });
    renderDisplayTableScrollButton(container);
  };

  inst.fillUsermgmtTableRow = (cols, item, viewButton) => {
    console.error("Not Implemented");
  };

  inst.buildUsermgmtPagination = (currentPage, itemPerPage, itemsLength) => {
    const totalPages = Math.floor((itemsLength - 1) / itemPerPage) + 1;
    const pagination = document.getElementById("usermgmt-pagination");
    // Remove old page
    const pages = pagination.querySelectorAll("[data-usermgmt-pagination='page']");
    pages.forEach(element => {
      element.parentNode.remove();
    });

    const oldPrev = pagination.querySelector("[data-usermgmt-pagination='previous']");
    const oldNext = pagination.querySelector("[data-usermgmt-pagination='next']");
    const prev = oldPrev.cloneNode(true);
    oldPrev.parentNode.replaceChild(prev, oldPrev);
    const next = oldNext.cloneNode(true);
    oldNext.parentNode.replaceChild(next, oldNext);

    if (currentPage > 1) {
      prev.addEventListener('click', () => inst.handlePaginationButtonOnClick(currentPage - 1));
    }
    if (currentPage < totalPages) {
      next.addEventListener('click', () => inst.handlePaginationButtonOnClick(currentPage + 1));
    }

    const padlen = 3;
    Array.from(Array(totalPages).keys()).forEach(i => {
      if (totalPages > 9 &&
        (currentPage - 1 <= padlen && i >= 9 ||
          i < currentPage - 1 - padlen ||
          (currentPage -1 > padlen && i > currentPage -1 + padlen)) &&
        i !== totalPages - 1 && i !== 0) {
        return ;
      }
      let pageTemplateId;
      if ((i + 1) === currentPage) { 
        pageTemplateId = "usermgmt-pagination-currentpage-template";
      } else {
        pageTemplateId = "usermgmt-pagination-page-template";
      }
      const pageTemplate = document.getElementById(pageTemplateId).cloneNode(true);
      const page = pageTemplate.content.querySelector("[data-usermgmt-pagination='page']");
      page.textContent = String(i + 1);
      if ((i + 1) !== currentPage) { 
        page.addEventListener('click', () => inst.handlePaginationButtonOnClick(i + 1));
      }
      // Add skip page
      if (i === totalPages - 1 && totalPages > 9 && currentPage < totalPages - (padlen + 1)) {
        const skipTemplate = document.getElementById("usermgmt-pagination-skippage-template")?.cloneNode(true);
        if (skipTemplate) {
          next.parentNode.before(skipTemplate.content.firstElementChild);
        }
      }
      next.parentNode.parentNode.insertBefore(pageTemplate.content.firstElementChild, next.parentNode);
      if (i === 0 && totalPages > 9 && currentPage > padlen + 1) {
        const skipTemplate = document.getElementById("usermgmt-pagination-skippage-template")?.cloneNode(true);
        if (skipTemplate) {
          next.parentNode.before(skipTemplate.content.firstElementChild);
        }
      }
    })
  };
  inst.renderViewItem = (itm) => {
    store.dispatch(actions.setChangeItem(itm));
    const form = document.getElementById("usermgmt-form");
    form.innerHTML = "";
    const footer = document.getElementById("usermgmt-modal-footer");
    footer.innerHTML = "";

    const formTable = document.getElementById("usermgmt-form-content").cloneNode(true).content.querySelector("table");

    form.appendChild(formTable);
    inst.renderViewItemContent(formTable, itm);
    inst.handleViewItemInputLabels(itm);

    // Handle update / delete button
    const buttons = document.getElementById("usermgmt-view-buttons-template").cloneNode(true).content.firstElementChild;
    footer.appendChild(buttons);

    const updateButton = buttons.querySelector("[data-usermgmt-form='updateitem']").querySelector("button");
    updateButton.addEventListener('click', (e) => inst.handleUpdateItemButtonOnClick(e));
    // if (updateButton) {
    //   updateButton.disabled = !inst.isUpdateItemButtonActive();
    // }
    const deleteButton = buttons.querySelector("[data-usermgmt-form='deleteitem']")
    deleteButton.addEventListener('click', (e) => inst.handleDeleteItemButtonOnClick(e));
  };

  inst.renderAddItem = () => {
    inst.store.dispatch(actions.clearChangeItem());
    const form = document.getElementById("usermgmt-form");
    form.innerHTML = "";
    const footer = document.getElementById("usermgmt-modal-footer");
    footer.innerHTML = "";

    const formTable = document.getElementById("usermgmt-form-content").cloneNode(true).content.querySelector("table");
    form.appendChild(formTable);
    inst.renderAddItemContent(formTable);

    const buttons = document.getElementById("usermgmt-add-buttons-template").cloneNode(true).content.firstElementChild;
    footer.appendChild(buttons);

    const addButton = buttons.querySelector("[data-usermgmt-form='additem']").querySelector("button");
    addButton.addEventListener('click', (e) => inst.handleAddItemButtonOnClick(e));
    // if (addButton) {
    //   addButton.disabled = !inst.isAddItemButtonActive();
    // }
  };

  inst.renderViewItemContent = (formTable, itm) => {
    console.error("Not implemented");
  };

  inst.renderAddItemContent = (formTable) => {
    console.error("Not implemented");
  };

  inst.handleClearButtonOnClick = () => {
    const {queryParams} = inst.store.getState();
    Object.keys(queryParams).forEach(name => {
      const labelContainer = document.querySelector(`[data-usermgmt-query='${name}']`);
      handleInputLabels(labelContainer);
    });
    store.dispatch(actions.clearQueryParams());
    store.dispatch(actions.getItems());
  };

  inst.handleSearchButtonOnClick = () => {
    if (!inst.isSearchButtonActive()) {
      return;
    }
    store.dispatch(actions.setPage());
    store.dispatch(actions.getItems());
  };

  inst.handleAddButtonOnClick = () => {
    handleModalOnToggleById("usermgmt-modal");
    inst.renderAddItem();
  };

  inst.handleExportButtonOnClick = () => {
    let confirmation = confirm("Are you sure to export all records?");
    if (confirmation) {
      const {filename, headers, recArrs} = inst.exportRecords();
      exportFullRecordCSV(filename, headers, recArrs);
    };
  };

  inst.handleViewButtonOnClick = (itm) => {
    handleModalOnToggleById("usermgmt-modal");
    inst.renderViewItem(itm);
  };

  inst.handleUpdateItemButtonOnClick = (e) => {
    e.preventDefault();
    if (!inst.isUpdateItemButtonActive()) {
      return;
    }
    let confirmation = confirm("Are you sure to update item?");
    if (confirmation) {
      store.dispatch(actions.updateItem());
      handleModalOnToggleById("usermgmt-modal");
    }
  };

  inst.handleDeleteItemButtonOnClick = (e) => {
    e.preventDefault();
    let confirmation = confirm("Are you sure to delete item?");
    if (confirmation) {
      store.dispatch(actions.deleteItem());
      handleModalOnToggleById("usermgmt-modal");
    }
  };

  inst.handleAddItemButtonOnClick = (e) => {
    e.preventDefault();
    if (!inst.isAddItemButtonActive()) {
      return;
    }
    let confirmation = confirm("Are you sure to create item?");
    if (confirmation) {
      store.dispatch(actions.createItem());
      handleModalOnToggleById("usermgmt-modal");
    }
  };

  inst.handleQueryInputOnChange = (name, value) => {
    const labelContainer = document.querySelector(`[data-usermgmt-query='${name}']`);
    handleInputLabels(labelContainer, value);
    store.dispatch(actions.setQueryParams({[name]: value}));
  };

  inst.handleFormInputOnChange = (name, value) => {
    const labelContainer = document.querySelector(`[data-usermgmt-detail='${name}']`);
    handleInputLabels(labelContainer, value);
    store.dispatch(actions.setChangeItem({[name]: value}));
  };

  inst.handlePaginationButtonOnClick = (targetPage) => {
    store.dispatch(actions.setPage(targetPage));
  };

  inst.handleViewItemInputLabels = (itm) => {
    Object.keys(itm).forEach(name => {
      const labelContainer = document.querySelector(`[data-usermgmt-detail='${name}']`);
      handleInputLabels(labelContainer, itm[name]);
    });
  };

  inst.isAddItemButtonActive = () => {
    console.log("isAddItemButtonActive to be implemented");
    return true;
  };

  inst.isUpdateItemButtonActive = () => {
    console.log("isUpdateItemButtonActive to be implemented");
    return true;
  };

  inst.isSearchButtonActive = () => {
    console.log("isSearchButtonActive to be implemented");
    return true;
  };

  inst.exportRecords = () => {
    console.log("exportRecords to be implemented");
    return {filename: null, headers: null, recArrs: null};
  };
  
  return inst;
};


