"use strict";

import {handleInputLabels} from '../common.js';
import { getFilterDateInputValue } from '../common.js';

export const getBaseUploadForm = (type, store, actions, typeName = 'tab') => {
  const inst = {};
  inst.tag = store.getState().tag;
  inst.formTypeName = typeName
  inst[typeName] = inst.formType = type;
  inst.store = store;
  inst.actions = actions;
  inst.store.subscribe(function(action) {
    const {[inst.formTypeName]: formType} = inst.store.getState();
    if (formType === inst.formType) {
      if (action.type === 'RESET_UPLOAD_ITEM') {
          inst.buildForm();
      }
    }
  });
  inst.initialize = function() {
    this.buildForm();
  };
  inst.buildForm = function() {
    const formTypeContentContainer = document.querySelector(`[data-${this.tag}='content']`);
    const form = formTypeContentContainer.querySelector(`[data-${this.tag}-${this.formType}='form']`);
    form.innerHTML = "";
    const formContent = formTypeContentContainer.querySelector(`[data-${this.tag}-${this.formType}='form-template']`).cloneNode(true).content;

    // // Perform type specific rendering
    this.renderFormItem(formContent);
    form.appendChild(formContent);

    this.renderSubmitButton();
  };
  inst.renderFormItem = function(content) {
    console.error("To be implemented");
  };
  inst.renderSubmitButton = function() {
    const formTypeContentContainer = document.querySelector(`[data-${this.tag}='content']`);
    const form = formTypeContentContainer.querySelector(`[data-${this.tag}-${this.formType}='form']`);
    const submitButton = form.querySelector(`[data-${this.tag}-${this.formType}='submit']`).querySelector("button");
    const submitClone = submitButton.cloneNode(true);
    submitClone.addEventListener('click', (e) => this.handleFormOnSubmit(e));
    // submitClone.disabled = !this.isFormSubmittable();
    submitButton.replaceWith(submitClone);
  };
  inst.handleUploadItemOnChange = function(name, target) {
    // handle input label
    const labelContainer = document.querySelector(`[data-${this.tag}-${this.formType}='${name}']`);
    let value;
    if (target.tagName === 'INPUT' && target.type) {
      if (target.type === 'file') {
        value = target.files.length ? target.files[0] : null;
      } else if (target.type === 'text') {
        value = target.value;
      } else if (target.type === 'checkbox') {
        value = target.checked;
      } else if (target.type === 'datetime-local' || target.type === 'date') {
        value = getFilterDateInputValue(name, target.value);
      }
    } else {
      value = target.value;
    }
    handleInputLabels(labelContainer, value, target.tagName);

    // Update store value
    this.store.dispatch(this.actions.setUploadItem({[name]: value}));

    // Handle Submit button
    // this.renderSubmitButton();
  };
  inst.handleUploadItemOnChangeByValue = function(name, value) {
    const labelContainer = document.querySelector(`[data-${this.tag}-${this.formType}='${name}']`);
    handleInputLabels(labelContainer, value);

    // Update store value
    this.store.dispatch(this.actions.setUploadItem({[name]: value}));

    // Handle Submit button
    // this.renderSubmitButton();
  };
  inst.handleFormOnSubmit = function(e) {
    e.preventDefault();
    if (!this.isFormSubmittable()) {
      return;
    }
    let confirmation = confirm("Are you sure to submit?");
    if (confirmation) {
      this.store.dispatch(this.actions.createUploadItem(this.formType));
    }
  };
  inst.isFormSubmittable = function() {
    console.log("To be implemented");
    return true;
  };
  return inst;
};
