"use strict";

import {toggleLoadingIcon} from '../common.js';

export const getBaseTabPage = (store, actions, contents) => {
  const inst = {};
  inst.tag = store.getState().tag;
  inst.store = store;
  inst.actions = actions;
  inst.contents = contents;
  inst.store.subscribe((action) => {
    if (action.type === 'SET_TAB') {
      const {tab} = inst.store.getState();
      inst.handleTabOnChange(tab);
    } else if (action.type === 'SET_RECORD_LOADING') {
      const {tab, recordLoading} = inst.store.getState();
      const table = document.querySelector(`[data-${inst.tag}-${tab}='table']`); 
      // inst.toggleDisableTab(tab, recordLoading);
      toggleLoadingIcon(table, recordLoading);
    }
  });
  inst.initialize = function() {
    const tabComponent = document.querySelector(`[data-${inst.tag}='tab']`);
    const tabs = tabComponent.querySelectorAll(`[data-${inst.tag}-tab]`);
    let firstTabName;
    tabs.forEach((t, idx) => {
      const tabName = t.getAttribute(`data-${inst.tag}-tab`);
      if (idx === 0) {
        firstTabName = tabName
      }
      t.addEventListener('click', () => this.handleTabOnClick(tabName));
    });
    this.store.dispatch(actions.setTab(firstTabName));
  };
  inst.handleTabOnChange = function(tabName) {
    // Breadcrumb
    const breadcrumbComponent = document.querySelector(`[data-${inst.tag}='breadcrumb']`);
    const breadcrumbs = breadcrumbComponent.querySelectorAll(`[data-${inst.tag}-breadcrumb]`);
    breadcrumbs.forEach(b => {
      if (b.getAttribute(`data-${inst.tag}-breadcrumb`) === tabName) {
        b.classList.remove('hidden');
      } else {
        b.classList.add('hidden');
      }
    });
    // Tab
    const tabComponent = document.querySelector(`[data-${inst.tag}='tab']`);
    const tabs = tabComponent.querySelectorAll(`[data-${inst.tag}-tab]`);
    tabs.forEach(t => {
      if (t.getAttribute(`data-${inst.tag}-tab`) === tabName) {
        t.disabled = true;
      } else {
        t.disabled = false;
      }
    });
    // Content
    const contentContainer = document.querySelector(`[data-${inst.tag}='content']`);
    contentContainer.innerHTML = "";
    const content = document.querySelector(`[data-${inst.tag}-content='${tabName}']`).cloneNode(true).content;
    contentContainer.appendChild(content);
    if (this.contents && this.contents[tabName]) {
      this.contents[tabName].initialize();
    }
  };
  inst.handleTabOnClick = function(tabName) {
    this.store.dispatch(actions.setTab(tabName));
  };
  inst.toggleDisableTab = function(tab, disabled) {
    const tabComponent = document.querySelector(`[data-${inst.tag}='tab']`);
    const tabs = tabComponent.querySelectorAll(`[data-${inst.tag}-tab]`);
    if (disabled) {
      tabs.forEach(t => {
        const newTab = t.cloneNode(true);
        t.replaceWith(newTab);
      });
    } else {
      tabs.forEach(t => {
        const tabName = t.getAttribute(`data-${inst.tag}-tab`);
        t.addEventListener('click', () => this.handleTabOnClick(tabName));
      });
    }
  };
  return Object.create(inst);
};
