"use strict";

import {toggleLoadingIcon} from '../common.js';

export const getBaseSelectFormPage = (store, actions, contents) => {
  const inst = {};
  inst.tag = store.getState().tag;
  inst.store = store;
  inst.actions = actions;
  inst.contents = contents;
  inst.store.subscribe((action) => {
    if (action.type === 'SET_FORMTYPE') {
      const {formtype} = inst.store.getState();
      inst.handleFormtypeOnChange(formtype);
    }
  });
  inst.initialize = function() {
    const contentContainer = document.querySelector(`[data-${inst.tag}='content']`);
    contentContainer.innerHTML = "";
    const formContainerTemplate = document.querySelector(`[data-${inst.tag}='formContainer']`);
    const form = formContainerTemplate.cloneNode(true).content;
    const formSelector = form.querySelector(`[data-${inst.tag}-form='selector']`);
    formSelector.addEventListener('change', (e) => this.handleFormSelectorOnChange(e.target.value));
    contentContainer.appendChild(form);
  };
  inst.handleFormtypeOnChange = function(type) {
    // Content
    const contentContainer = document.querySelector(`[data-${inst.tag}='content']`);
    const formContainer = contentContainer.querySelector(`[data-${inst.tag}-form='content']`);
    formContainer.innerHTML = "";
    const template = document.querySelector(`[data-${inst.tag}-content='${type}']`);
    if (template) {
      const formContent = template.cloneNode(true).content;
      formContainer.appendChild(formContent);
      if (this.contents && this.contents[type]) {
        this.contents[type].initialize();
      }
    }
  };
  inst.handleFormSelectorOnChange = function(formtype) {
    this.store.dispatch(actions.setFormtype(formtype));
  }
  return Object.create(inst);
};
