import { handleInputLabels, handleModalOnToggleById } from "../common.js";

export const getLicensePage = (store, actions) => {
  const inst = {};
  inst.name = "getLicensePage";
  inst.store = store;
  inst.actions = actions;
  inst.initialize = function () {
    this.store.subscribe((action) => {
      // Subscribe to actions
      if (action.type === "UPLOAD_SUCCESS") {
        handleModalOnToggleById("license-modal");
        if (window !== undefined) {
          setTimeout(() => {
            window.location.reload();
          }, 0);
        }
      }
    });
    this.buildPage();
  };
  inst.buildPage = function () {
    const licenseCard = document.getElementById("license-card");
    if (!licenseCard) {
      console.error("License card not found");
      return;
    }
    const addButton = licenseCard
      .querySelector("[data-license-card='addBtn']")
      ?.querySelector("button");
    if (!!addButton) {
      addButton.addEventListener("click", () => this.handleAddButtonOnClick());
    }
  };
  inst.buildForm = function () {
    const modal = document.getElementById("license-modal");
    const form = modal.querySelector("form");
    form.innerHTML = "";
    this.store.dispatch(this.actions.reset());
    const formContentTemplate = document
      .getElementById("license-form-template")
      .cloneNode(true);
    const submitButton = modal
      .querySelector("[data-license-form='submit']")
      .querySelector("button");
    const submitClone = submitButton.cloneNode(true);
    submitClone.addEventListener("click", (e) => this.handleFormOnSubmit(e));
    submitButton.replaceWith(submitClone);
    this.renderFormItem(formContentTemplate.content);
    form.appendChild(formContentTemplate.content);
    handleModalOnToggleById("license-modal");
  };
  inst.handleAddButtonOnClick = function () {
    this.buildForm();
  };
  inst.handleFormOnSubmit = function (e) {
    e.preventDefault();
    if (!this.isFormSubmittable()) {
      alert("Please select a license file to upload.");
      return;
    }
    let confirmation = confirm("Are you sure to upload license?");
    if (confirmation) {
      this.store.dispatch(this.actions.uploadLicense());
    }
  };
  inst.isFormSubmittable = function () {
    const { license } = this.store.getState();
    return license !== null;
  };
  inst.renderFormItem = function (content) {
    const license = content.querySelector("[data-license-form='license']");
    const licenseInput = license.querySelector("input");
    licenseInput.addEventListener("change", (e) =>
      this.handleLicenseInputOnChange(
        e.target.files.length ? e.target.files[0] : null
      )
    );
  };
  inst.handleLicenseInputOnChange = function (value) {
    const labelContainer = document.querySelector(
      "[data-license-form='license']"
    );
    handleInputLabels(labelContainer, value);
    this.store.dispatch(this.actions.setLicense(value));
  };
  return inst;
};