"use strict";

import {handleInputLabels, handleModalOnToggle} from '../common.js';
import {convertDatetimeToLocaleString} from '../common.js';
import {b64ToBlob, downloadBlob, getFileExtensionFromMimeType} from '../common.js';

export const getHistoryModal = () => {
  const inst = {};
  inst.setTemplate = function(template) {
    this._template = template;
  };
  inst.getTemplate = function() {
    if (!this._template) {
      console.error("Modal content template not set");
    }
    return this._template;
  };
  inst.setContainer = function(container) {
    this._container = container;
  };
  inst.getContainer = function() {
    if (!this._container) {
      console.error("Modal container not set");
    }
    return this._container;
  };
  inst.buildModalContent = function(detail) {
    const template = this.getTemplate();
    const container = this.getContainer();
    const contentContainer = container.querySelector("[data-modal='content']");
    // Clean up container
    contentContainer.innerHTML = "";
    const modalCloseButtons = container.querySelectorAll("[data-modal='close-button']");
    Array.from(modalCloseButtons).forEach(btn => {
      btn.addEventListener('click', () => this.onClose())
    });

    const content = template.cloneNode(true).content;
    this.renderModalContent(content, detail);
    contentContainer.appendChild(content);
  };
  inst.buildModalFooter = function(detail) {
    const container = this.getContainer();
    const footerContainer = container.querySelector("[data-modal='footer']");
    this.renderModalFooter(footerContainer, detail);
  };
  inst.renderModalContent = function(content, detail) {
    console.error("Not implemented");
  };
  inst.renderModalFooter = function(footerContainer) {
    console.error("Not implemented");
  };
  inst.handleHistoryModalOnToggle = function(params) {
    // Only Activated on open
    const container = this.getContainer();
    if (container.classList.contains('hidden')) {
      this.onActivate(params);
    }
    handleModalOnToggle(container);
  };
  inst.onActivate = function(params) {
    // Do nothing
    console.log("Not implemented");
  };
  inst.onClose = function() {
    const container = this.getContainer();
    const contentContainer = container.querySelector("[data-modal='content']");
    // Clean up container
    contentContainer.innerHTML = "";
  };
  inst.close = function() {
    const container = this.getContainer();
    const closeBtn = container.querySelector("[data-modal='close-button']");
    closeBtn.click();
  };
  return inst;
};

export const renderCRAResponse = (tag, list, resp) => {
  renderGeneralCRAResponse(tag, list, resp);
};
export const renderRepliedMessageResponse = (tag, list, resp, repliedMsgType = 'repliedmsg') => {
  renderGeneralCRAResponse(tag, list, resp, repliedMsgType);
};
export const renderReminderMessageResponse = (tag, list, resp) => {
  renderGeneralCRAResponse(tag, list, resp, 'remindermsg');
};
const renderGeneralCRAResponse = (tag, list, resp, componentName = 'craresp') => {
  const mimeType = resp.dataMimeType ? resp.dataMimeType : '';
  let craRespTemplate;
  if (mimeType === 'text/plain') {
    craRespTemplate = document.getElementById(`history-modal-${tag}-${componentName}-txt`);
  } else {
    craRespTemplate = document.getElementById(`history-modal-${tag}-${componentName}-file`);
  }
  // resp: messageId, message, dataFileName, dataMimeType
  const craRespContainer = craRespTemplate.cloneNode(true).content;
  const sourceInput = craRespContainer.querySelector(`[data-${tag}-detail='source'`)?.querySelector("input");
  if (sourceInput && resp.source) {
    sourceInput.value = resp.source;
  }
  const dcrResultInput = craRespContainer.querySelector(`[data-${tag}-detail='dcrResult'`)?.querySelector("input");
  if (dcrResultInput && resp.dcrResult) {
    dcrResultInput.value = resp.dcrResult;
  }
  const createDatetimeInput = craRespContainer.querySelector(`[data-${tag}-detail='createDatetime'`)?.querySelector("input");
  if (createDatetimeInput && resp.createDatetime) {
    createDatetimeInput.value = convertDatetimeToLocaleString(resp.createDatetime);
  }
  const messageIdInput = craRespContainer.querySelector(`[data-${tag}-detail='messageId'`).querySelector("input");
  messageIdInput.value = resp.messageId;
  const messageInput = craRespContainer?.querySelector(`[data-${tag}-detail='message'`)?.querySelector("textarea");
  if (messageInput && mimeType === 'text/plain' && resp.message) {
    messageInput.value = atob(resp.message);
  }
  const dataMimeTypeInput = craRespContainer?.querySelector(`[data-${tag}-detail='dataMimeType'`)?.querySelector("input");
  if (dataMimeTypeInput && mimeType) {
    dataMimeTypeInput.value = mimeType;
  }
  let fileName = resp.dataFileName ? resp.dataFileName : `${resp.messageId}_${resp.source}_response`;
  const fileExtension = getFileExtensionFromMimeType(mimeType);
  if (fileExtension) {
    fileName = fileName + `.${fileExtension}`;
  }
  const dataFileNameInput = craRespContainer?.querySelector(`[data-${tag}-detail='dataFileName'`)?.querySelector("input");
  if (dataFileNameInput) {
    dataFileNameInput.value = fileName;
  }
  const downloadButton = craRespContainer?.querySelector(`[data-${tag}-detail='download'`);
  if (downloadButton) {
    if (resp.message) {
      const fileDownloader = () => {
        const b64Message = resp.message;
        const blob = b64ToBlob(b64Message, mimeType);
        downloadBlob(blob, fileName);
      };
      downloadButton.addEventListener('click', () => fileDownloader());
    } else {
      downloadButton.classList.add("hidden");
    }
  }
  list.appendChild(craRespContainer);
};

export const renderCRPResponse = (tag, crpResp, resp) => {
  if (resp) {
    const crpRespTemplate = document.getElementById(`history-modal-${tag}-crpresp`);
    const content = crpRespTemplate.cloneNode(true).content;
    const returnCodeInput = content.querySelector(`[data-${tag}-detail='returnCode']`).querySelector("input");
    returnCodeInput.value = resp ? resp.returnCode : "";
    const returnDescInput = content.querySelector(`[data-${tag}-detail='returnDescription']`).querySelector("input");
    returnDescInput.value = resp ? resp.returnDescription : "";
    crpResp.appendChild(content);
  } else {
    const noRecord = document.getElementById('history-modal-no-resp').cloneNode(true).content;
    crpResp.appendChild(noRecord);
  }

}
export const renderCreditReportResponse = (tag, credrptList, resp) => {
  const credrptTemplate = document.getElementById(`history-modal-${tag}-crpresp`);
  const content = credrptTemplate.cloneNode(true).content;
  const sourceInput = content.querySelector(`[data-${tag}-detail='generatedCRA'`).querySelector("input");
  sourceInput.value = resp.generatedCRA;
  const messageIdInput = content.querySelector(`[data-${tag}-detail='messageId'`).querySelector("input");
  messageIdInput.value = resp.messageId;
  const reportArchiveInput = content.querySelector(`[data-${tag}-detail='reportFileName'`).querySelector("input");
  reportArchiveInput.value = resp.reportFileName;
  

  crpResp.appendChild(content);
}
