"use strict";

export const getFormArrayItem = () => {
  const inst = {};
  inst.initialize = function(container, template) {
    this.setTemplate(template);
    this.setContainer(container);
    this._lastKey = null; // unique identifier to every item added
    this._values = {};
    // Clean up container
    container.innerHTML = "";
    const newItem = this.getNewItem(template.cloneNode(true).content);
    // Set arrayItemIndex
    container.appendChild(newItem);
  };
  inst.getNewKey = function() {
    if (this._lastKey === null) {
      this._lastKey = 0;
    } else {
      this._lastKey = this._lastKey + 1;
    }
    return String(this._lastKey);
  };
  inst.getValues = function() {
    return Object.keys(this._values).sort().filter(k => this._values[k]).map(k => this._values[k]);
  };
  inst.setTemplate = function(template) {
    if (template) {
      this._template = template;
    } else {
      this._template = null;
    }
  };
  inst.getTemplate = function() {
    return this._template;
  };
  inst.setContainer = function(container) {
    if (container) {
      this._container = container;
    } else {
      this._container = null;
    }
  };
  inst.getContainer = function() {
    return this._container;
  };
  inst.getNewItem = function(templateContent) {
    const newKey = this.getNewKey();
    templateContent.querySelector("[data-form-arrayitem-key]").setAttribute("data-form-arrayitem-key", newKey);

    const addButton = templateContent.querySelector("[data-form-arrayitem='add']");
    addButton.addEventListener('click', () => this.handleAddButtonOnClick());
    addButton.classList.remove('hidden');

    const removeButton = templateContent.querySelector("[data-form-arrayitem='remove']");
    removeButton.addEventListener('click', () => this.handleRemoveButtonOnClick(newKey));
    removeButton.classList.add('hidden');
    const input = templateContent.querySelector("input");
    input.addEventListener('change', (e) => this.handleValueOnChange(newKey, e.target));

    return templateContent;
  };
  inst.handleAddButtonOnClick = function() {
    // Add item
    const container = this.getContainer();
    const template = this.getTemplate();
    const newItem = this.getNewItem(template.cloneNode(true).content);
    container.appendChild(newItem);
    // Update visible button
    Array.from(container.children).map(item => {
      const itemKey = item.getAttribute("data-form-arrayitem-key");    
      const addButton = item.querySelector("[data-form-arrayitem='add']");
      const removeButton = item.querySelector("[data-form-arrayitem='remove']");
      if (itemKey === String(this._lastKey)) {
        addButton.classList.remove('hidden');
        removeButton.classList.add('hidden');
      } else {
        addButton.classList.add('hidden');
        removeButton.classList.remove('hidden');
      }
    });
  };
  inst.handleRemoveButtonOnClick = function(key) {
    const container = this.getContainer();
    const removeItem = Array.from(container.children).find(item => {
      const itemKey = item.getAttribute("data-form-arrayitem-key");    
      return (itemKey === key);
    });
    removeItem.remove();
    // Remove item from values map
    delete this._values[key];
    this.arrayItemOnChange(this.getValues());
  };
  inst.handleValueOnChange = function(key, target) {
    if (target.type === 'file') {
      this._values[key] = target.files.length ? target.files[0] : null;
    } else if (target.type === 'text') {
      this._values[key] = target.value;
    } else {
      console.error("Not implemented");
    }
    this.arrayItemOnChange(this.getValues());
  };
  inst.arrayItemOnChange = function(values) {
    console.error("Not implemented");
  };
  return Object.create(inst);
};
