"use strict";

import {BaseApproval} from './component/approval_component.js';
import {getHistoryModal} from './component/history_modal.js';
import {store, actions} from './model/approval_model.js';
import {getDXULRenderer, getCRULRenderer, getDCRRRenderer, getPXCRRenderer,
        getSUGXRenderer, getSDPXRenderer, getSUSXRenderer} from './approval_renderer.js';
import {toggleLoadingIcon} from './common.js';

// DSUL : 'Data Submission Upload',
// DAUL : 'Data Amendment Upload',
// IDUL : 'Initial Data Load Upload',
// CRUL : 'Credit Report Enquiry Upload',
// PDUL : 'PMDS Data Submission Upload',
// PCUL : 'PMDS Credit Report Enquiry Upload',
// DCRR : 'Data Correction Request Reply',
//
// SUSC : 'Create User',
// SUSU : 'Update User',
// SUSS : 'Update User Status',
// SUSD : 'Delete User',
//
// SUGC : 'Create User Group',
// SUGU : 'Update User Group',
// SUGD : 'Delete User Group', 
//
// SDPC : 'Create Department',
// SDPU : 'Update Department',
// SDPD : 'Delete Department',
//
// PPCR: 'PMDS Prescribed Consent List Reply'
// PWCR: 'Withdrawal of PMDS Prescribed Consent List Reply'

const ApprovalRequestModalSetter = (inst, modal, reqType, renderer) => {
  let detailType;
  if (reqType === 'DSUL' || reqType === 'DAUL' || reqType === 'IDUL') {
    detailType = 'DXUL';
  } else if (reqType === 'SUGC' || reqType === 'SUGU' || reqType === 'SUGD') {
    detailType = 'SUGX';
  } else if (reqType === 'SUSC' || reqType === 'SUSU' || reqType === 'SUSD' || reqType === 'SUSS') {
    detailType = 'SUSX';
  } else if (reqType === 'SDPC' || reqType === 'SDPU' || reqType === 'SDPD') {
    detailType = 'SDPX';
  } else if (reqType === 'PWCR' || reqType === 'PPCR') {
    detailType = 'PXCR';
  } else {
    detailType = reqType
  }
  const setModal = () => {
    const currentUser = document.querySelector(`[data-${inst.tag}='user']`).value;
    const tab = 'request';
    const container = document.querySelector(`[data-${inst.tag}='content']`).querySelector("#detail-modal");
    modal.setContainer(container);
    let template
    if (detailType === 'DXUL' || detailType === 'CRUL' || detailType === 'PDUL' || detailType === 'PCUL') {
      template = document.getElementById(`${detailType}-modal-content-template`);
    } else if (detailType === 'SUGX' || detailType === 'SDPX' || detailType === 'SUSX') {
      template = document.getElementById(`${inst.tag}-${detailType}-form-content`);
    } else if (detailType === 'DCRR') {
      template = document.getElementById("dcrr-modal-content-template");
    } else if (detailType === 'PXCR') {
      if (reqType === 'PPCR') {
        template = document.getElementById("pmds-prescribed-consent-list-modal-content-template");
      } else if (reqType === 'PWCR') {
        template = document.getElementById("pmds-withdrawal-prescribed-consent-list-modal-content-template");
      }
    }
    modal.setTemplate(template);
    modal.onActivate = function(params) {
      inst.store.dispatch(inst.actions.getDetailInfo(params));
    };
    modal.renderModalContent = function(content, detail) {
      // Replae title
      const container = modal.getContainer();
      const titleElement = container.querySelector("[data-modal='title']");
      titleElement.textContent = 'detail';
      const approvalSpan = document.getElementById("approval-requestType-span").content.querySelector(`[data-approval-span='${reqType}']`);
      if (approvalSpan) {
        titleElement.textContent = approvalSpan.textContent;
      }
      // Render content with renderer
      const render = renderer(inst, reqType);
      render(content, detail);
    };
    modal.handleActionRequest = (id, action) => {
      let confirmation = confirm(`Are you sure to ${action} approval request?`);
      if (confirmation) {
        inst.store.dispatch(inst.actions.actionRequest(id, action));
      }
    };
    modal.renderModalFooter = function(container, detail) {
      const {detailUser, detailId} = inst.store.getState();
      ['approve', 'reject', 'cancel'].forEach(action => {
        const oldActionButton = container.querySelector(`[data-${inst.tag}-detail='${action}']`).querySelector("button");
        oldActionButton.parentNode.classList.remove('hidden');
        const actionButton = oldActionButton.cloneNode(true);
        if (detailUser === currentUser) {
          if (action === 'cancel') {
            actionButton.addEventListener('click', () => modal.handleActionRequest(detailId, action));
            actionButton.classList.remove('hidden');
          } else {
            actionButton.classList.add('hidden');
          }
        } else {
          if (action === 'cancel') {
            actionButton.classList.add('hidden');
          } else {
            actionButton.addEventListener('click', () => modal.handleActionRequest(detailId, action));
            actionButton.classList.remove('hidden');
          }
        }
        oldActionButton.replaceWith(actionButton);
      });
    };
  };
  return setModal;
};


export const ApprovalRequest = (store, actions) => {
  const inst = Object.create(BaseApproval('request', store, actions));
  inst.store.subscribe((action) => {
    if (action.type === 'SET_DETAIL') {
      const {detail, requestType, detailUser} = inst.store.getState();
      const currentModal = inst.getModal(requestType);
      if (currentModal) {
        currentModal.buildModalFooter(detail);
        currentModal.buildModalContent(detail);
      }
    } else if (action.type === 'UNSET_DETAIL_INFO') {
      const {lastRequestType} = inst.store.getState();
      const currentModal = inst.getModal(lastRequestType);
      if (currentModal) {
        currentModal.close();
      }
    } else if (action.type === 'SET_DETAIL_LOADING') {
      const {detailLoading, requestType} = inst.store.getState();
      const currentModal = inst.getModal(requestType);
      const modalContainer = currentModal.getContainer();
      if (modalContainer) {
        toggleLoadingIcon(modalContainer, detailLoading);
      }
    }
  });
  const createModalMap = () => {
    const modalMap = {};
    ['DSUL', 'DAUL', 'IDUL', 'CRUL', 'PDUL', 'PCUL', 'DCRR',
     'SUGC', 'SUGU', 'SUGD', 
     'SDPC', 'SDPU', 'SDPD',
     'SUSC', 'SUSU', 'SUSD', 'SUSS',
     'PPCR', 'PWCR'].forEach(detailType => {
      modalMap[detailType] = {
        modal: getHistoryModal()
      }
    });
    modalMap['DSUL'].setModal = ApprovalRequestModalSetter(inst, modalMap['DSUL'].modal, 'DSUL', getDXULRenderer);
    modalMap['DAUL'].setModal = ApprovalRequestModalSetter(inst, modalMap['DAUL'].modal, 'DAUL', getDXULRenderer);
    modalMap['IDUL'].setModal = ApprovalRequestModalSetter(inst, modalMap['IDUL'].modal, 'IDUL', getDXULRenderer);
    modalMap['CRUL'].setModal = ApprovalRequestModalSetter(inst, modalMap['CRUL'].modal, 'CRUL', getCRULRenderer);
    modalMap['PDUL'].setModal = ApprovalRequestModalSetter(inst, modalMap['PDUL'].modal, 'PDUL', getDXULRenderer);
    modalMap['PCUL'].setModal = ApprovalRequestModalSetter(inst, modalMap['PCUL'].modal, 'PCUL', getCRULRenderer);
    modalMap['DCRR'].setModal = ApprovalRequestModalSetter(inst, modalMap['DCRR'].modal, 'DCRR', getDCRRRenderer);
    modalMap['SUGC'].setModal = ApprovalRequestModalSetter(inst, modalMap['SUGC'].modal, 'SUGC', getSUGXRenderer);
    modalMap['SUGU'].setModal = ApprovalRequestModalSetter(inst, modalMap['SUGU'].modal, 'SUGU', getSUGXRenderer);
    modalMap['SUGD'].setModal = ApprovalRequestModalSetter(inst, modalMap['SUGD'].modal, 'SUGD', getSUGXRenderer);
    modalMap['SDPC'].setModal = ApprovalRequestModalSetter(inst, modalMap['SDPC'].modal, 'SDPC', getSDPXRenderer);
    modalMap['SDPU'].setModal = ApprovalRequestModalSetter(inst, modalMap['SDPU'].modal, 'SDPU', getSDPXRenderer);
    modalMap['SDPD'].setModal = ApprovalRequestModalSetter(inst, modalMap['SDPD'].modal, 'SDPD', getSDPXRenderer);
    modalMap['SUSC'].setModal = ApprovalRequestModalSetter(inst, modalMap['SUSC'].modal, 'SUSC', getSUSXRenderer);
    modalMap['SUSU'].setModal = ApprovalRequestModalSetter(inst, modalMap['SUSU'].modal, 'SUSU', getSUSXRenderer);
    modalMap['SUSD'].setModal = ApprovalRequestModalSetter(inst, modalMap['SUSD'].modal, 'SUSD', getSUSXRenderer);
    modalMap['SUSS'].setModal = ApprovalRequestModalSetter(inst, modalMap['SUSS'].modal, 'SUSS', getSUSXRenderer);
    modalMap['PPCR'].setModal = ApprovalRequestModalSetter(inst, modalMap['PPCR'].modal, 'PPCR', getPXCRRenderer);
    modalMap['PWCR'].setModal = ApprovalRequestModalSetter(inst, modalMap['PWCR'].modal, 'PWCR', getPXCRRenderer);

    return modalMap;
  };
  inst.modalMap = createModalMap();
  inst.getModal = function(requestType) {
    const modalItem = inst.modalMap[requestType];
    if (modalItem) {
      return modalItem.modal;
    } else {
      alert(`Unregconized requestType ${requestType}`);
    }
  };
  inst.initialize = function() {
    Object.keys(this.modalMap).forEach(reqType => {
      this.modalMap[reqType].setModal();
    });
    this._pInitialize = Object.getPrototypeOf(this).initialize;
    this._pInitialize();
  };
  return inst;
};
