/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.credit_reference_platform.crp.gateway.security.configuration;

import com.gitlab.credit_reference_platform.crp.gateway.system.activity.dto.ActivityDTO;
import com.gitlab.credit_reference_platform.crp.gateway.system.activity.enum_type.ActivityActionType;
import com.gitlab.credit_reference_platform.crp.gateway.system.activity.enum_type.ActivityCategory;
import com.gitlab.credit_reference_platform.crp.gateway.system.activity.enum_type.ActivityStatus;
import com.gitlab.credit_reference_platform.crp.gateway.system.activity.enum_type.ActivityType;
import com.gitlab.credit_reference_platform.crp.gateway.system.activity.service.IActivityService;
import com.gitlab.credit_reference_platform.crp.gateway.usermgmt.service.IUserService;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class PortalAuthenticationFailureHandler
extends SimpleUrlAuthenticationFailureHandler {
    @Autowired
    private IUserService userService;
    @Autowired
    private IActivityService activityService;
    public static final String CREDENTIALS_EXPIRED_USERNAME = "LOGIN_CREDENTIALS_EXPIRED_USERNAME";

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        this.saveException(request, exception);
        String username = request.getParameter("username");
        if (exception instanceof CredentialsExpiredException) {
            this.saveUsername(request, username);
            this.setDefaultFailureUrl("/change-password");
        } else {
            this.userService.incrementLoginFailedCount(username);
            this.setDefaultFailureUrl("/login");
        }
        if (StringUtils.hasText((String)username)) {
            this.insertActivityRecord(username);
        }
        super.onAuthenticationFailure(request, response, exception);
    }

    protected final void saveUsername(HttpServletRequest request, String username) {
        if (this.isUseForward()) {
            request.setAttribute(CREDENTIALS_EXPIRED_USERNAME, (Object)username);
            return;
        }
        HttpSession session = request.getSession(false);
        if (session != null || this.isAllowSessionCreation()) {
            request.getSession().setAttribute(CREDENTIALS_EXPIRED_USERNAME, (Object)username);
        }
    }

    protected void insertActivityRecord(String username) {
        ActivityDTO activity = new ActivityDTO();
        activity.setCategory(ActivityCategory.SYSTEM);
        activity.setType(ActivityType.USER_LOGIN);
        activity.setActionType(ActivityActionType.ACTION);
        activity.setActivityUsername(username);
        activity.setActivityTime(Instant.now());
        activity.setActivityMessage("Login attempt failed");
        activity.setStatus(ActivityStatus.FAILED);
        this.activityService.insertActivityRecord(activity);
    }
}

