/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.credit_reference_platform.crp.gateway.security.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.gitlab.credit_reference_platform.crp.gateway.constant.ApiResponseCode;
import com.gitlab.credit_reference_platform.crp.gateway.constant.IApiResponseCode;
import com.gitlab.credit_reference_platform.crp.gateway.exception.ServiceException;
import com.gitlab.credit_reference_platform.crp.gateway.http.security.token.OAuth2AuthenticationToken;
import com.gitlab.credit_reference_platform.crp.gateway.mapper.ObjectMapperConfiguration;
import com.gitlab.credit_reference_platform.crp.gateway.model.GenericApiResponse;
import com.gitlab.credit_reference_platform.crp.gateway.oauth2.service.IOAuth2Service;
import com.gitlab.credit_reference_platform.crp.gateway.security.authority.CRPGatewayGrantedAuthorities;
import com.gitlab.credit_reference_platform.crp.gateway.utils.GenericApiResponseUtils;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.hc.core5.http.ContentType;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class OAuth2AuthFilter
implements Filter {
    public static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String AUTHORIZATION_PREFIX = "Bearer ";
    private static final Collection<GrantedAuthority> CRP_GRANTED_AUTHORITIES = Collections.singleton(CRPGatewayGrantedAuthorities.CRP);
    private IOAuth2Service oAuth2Service;

    public OAuth2AuthFilter(IOAuth2Service oAuth2Service) {
        Assert.notNull((Object)oAuth2Service, (String)"oAuth2Service cannot be null for OAuth2AuthFilter");
        this.oAuth2Service = oAuth2Service;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String authorization;
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse && StringUtils.hasText((String)(authorization = ((HttpServletRequest)request).getHeader(AUTHORIZATION_HEADER))) && authorization.startsWith(AUTHORIZATION_PREFIX)) {
            boolean verified = false;
            String authToken = authorization.substring(AUTHORIZATION_PREFIX.length());
            try {
                verified = this.oAuth2Service.verifyToken(authToken);
            }
            catch (ServiceException e) {
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                httpResponse.setStatus(400);
                httpResponse.setContentType(ContentType.APPLICATION_JSON.getMimeType());
                GenericApiResponse apiResponse = GenericApiResponseUtils.errorResponse(GenericApiResponse.class, (IApiResponseCode)ApiResponseCode.SYSTEM_ERROR, (String)"System error");
                ObjectMapper objectMapper = ObjectMapperConfiguration.createObjectMapper();
                httpResponse.getWriter().write(objectMapper.writeValueAsString((Object)apiResponse));
                return;
            }
            OAuth2AuthenticationToken token = new OAuth2AuthenticationToken(authToken, CRP_GRANTED_AUTHORITIES);
            SecurityContextHolder.getContext().setAuthentication((Authentication)token);
            if (!verified) {
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                httpResponse.setStatus(401);
                httpResponse.setContentType(ContentType.APPLICATION_JSON.getMimeType());
                GenericApiResponse apiResponse = GenericApiResponseUtils.errorResponse(GenericApiResponse.class, (IApiResponseCode)ApiResponseCode.INVALID_AUTHORIZATION, (String)"Invalid Authorization");
                ObjectMapper objectMapper = ObjectMapperConfiguration.createObjectMapper();
                httpResponse.getWriter().write(objectMapper.writeValueAsString((Object)apiResponse));
                return;
            }
        }
        chain.doFilter(request, response);
    }
}

