/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.credit_reference_platform.crp.gateway.security.configuration;

import com.gitlab.credit_reference_platform.crp.gateway.constants.GatewayURL;
import com.gitlab.credit_reference_platform.crp.gateway.license.CRPGatewayLicense;
import com.gitlab.credit_reference_platform.crp.gateway.license.LicenseInfo;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class LicenseFilter
implements Filter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LicenseFilter.class);
    private static final RequestMatcher EXCLUDED_REQUEST_MATCHER = GatewayURL.AntMatcherBuilder.builder().addAntPath("/api/v1/license").addAntPaths(new String[]{"/js/**", "/css/**", "/img/**"}).addAntPath("/error").build();
    private static final RequestMatcher LICENSE_REQUEST_MATCHER = new AntPathRequestMatcher("/license");

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean licenseValid = Optional.ofNullable(CRPGatewayLicense.licenseInfo).map(LicenseInfo::isValid).orElse(false);
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            if (response instanceof HttpServletResponse) {
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                if (!EXCLUDED_REQUEST_MATCHER.matches(httpRequest)) {
                    if (licenseValid && LICENSE_REQUEST_MATCHER.matches(httpRequest)) {
                        httpResponse.sendRedirect("/");
                        return;
                    }
                    if (!licenseValid && !LICENSE_REQUEST_MATCHER.matches(httpRequest)) {
                        httpResponse.sendRedirect("/license");
                        return;
                    }
                }
            }
        }
        chain.doFilter(request, response);
    }
}

