/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.credit_reference_platform.crp.gateway.security.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.gitlab.credit_reference_platform.crp.gateway.constant.ApiResponseCode;
import com.gitlab.credit_reference_platform.crp.gateway.constant.IApiResponseCode;
import com.gitlab.credit_reference_platform.crp.gateway.http.security.token.ApiKeyAuthenticationToken;
import com.gitlab.credit_reference_platform.crp.gateway.mapper.ObjectMapperConfiguration;
import com.gitlab.credit_reference_platform.crp.gateway.model.GenericApiResponse;
import com.gitlab.credit_reference_platform.crp.gateway.security.authority.CRPGatewayGrantedAuthorities;
import com.gitlab.credit_reference_platform.crp.gateway.utils.GenericApiResponseUtils;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.hc.core5.http.ContentType;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ApiKeyAuthFilter
implements Filter {
    public static final String API_KEY_HEADER = "apiKey";
    private static final Collection<GrantedAuthority> API_GRANTED_AUTHORITIES = Collections.singleton(CRPGatewayGrantedAuthorities.API);
    private final String authorizedApiKey;

    public ApiKeyAuthFilter(String authorizedApiKey) {
        Assert.hasText((String)authorizedApiKey, (String)"authorizedApiKey cannot be empty for ApiKeyAuthFilter");
        this.authorizedApiKey = authorizedApiKey;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String apiKey;
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse && StringUtils.hasText((String)(apiKey = ((HttpServletRequest)request).getHeader(API_KEY_HEADER)))) {
            if (this.authorizedApiKey.equals(apiKey)) {
                ApiKeyAuthenticationToken token = new ApiKeyAuthenticationToken(apiKey, API_GRANTED_AUTHORITIES);
                SecurityContextHolder.getContext().setAuthentication((Authentication)token);
            } else {
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                httpResponse.setStatus(401);
                httpResponse.setContentType(ContentType.APPLICATION_JSON.getMimeType());
                GenericApiResponse apiResponse = GenericApiResponseUtils.errorResponse(GenericApiResponse.class, (IApiResponseCode)ApiResponseCode.INVALID_API_KEY, (String)"Invalid API Key");
                ObjectMapper objectMapper = ObjectMapperConfiguration.createObjectMapper();
                httpResponse.getWriter().write(objectMapper.writeValueAsString((Object)apiResponse));
                return;
            }
        }
        chain.doFilter(request, response);
    }
}

