/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.credit_reference_platform.crp.gateway.portal.model;

import com.gitlab.credit_reference_platform.crp.gateway.portal.model.NavItem;
import com.gitlab.credit_reference_platform.crp.gateway.portal.model.NavMenuItem;
import com.gitlab.credit_reference_platform.crp.gateway.portal.utils.PortalUtils;
import com.gitlab.credit_reference_platform.crp.gateway.security.user.PortalUserDetails;
import com.gitlab.credit_reference_platform.crp.gateway.usermgmt.dto.RoleDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

public class NavMenu
extends ArrayList<NavMenuItem> {
    public static final String MENU_SOURCE_JSON = "classpath:portal_nav_settings.json";
    private static final long serialVersionUID = 3966148358899332664L;

    public NavMenu toPermissionedMenu() {
        NavMenu newMenu = new NavMenu();
        PortalUserDetails userDetails = PortalUtils.getPortalUserDetails();
        if (userDetails == null) {
            return newMenu;
        }
        Collection userRoles = userDetails.getRoles();
        for (NavMenuItem menuItem : this) {
            if (!this.hasAnyPermissions(userRoles, (Collection)menuItem.getPermissions())) continue;
            List children = menuItem.getChildren();
            if (children == null || children.isEmpty()) {
                newMenu.add((Object)menuItem);
                continue;
            }
            List newChildren = this.processChildrenPermission(children, userRoles);
            if (newChildren.isEmpty()) continue;
            NavMenuItem newMenuItem = new NavMenuItem();
            newMenuItem.setIcon(menuItem.getIcon());
            newMenuItem.setName(menuItem.getName());
            newMenuItem.setPath(menuItem.getPath());
            newMenuItem.setPermissions(menuItem.getPermissions());
            newMenuItem.setChildren(newChildren);
            newMenu.add((Object)newMenuItem);
        }
        return newMenu;
    }

    private List<NavItem> processChildrenPermission(List<NavItem> children, Collection<RoleDTO> userRoles) {
        ArrayList<NavItem> processed = new ArrayList<NavItem>();
        if (children == null || children.isEmpty()) {
            return processed;
        }
        for (NavItem item : children) {
            if (!this.hasAnyPermissions(userRoles, (Collection)item.getPermissions())) continue;
            processed.add(item);
        }
        return processed;
    }

    private boolean hasAnyPermissions(Collection<RoleDTO> userRoles, Collection<Integer> requiredPermissions) {
        if (requiredPermissions == null || requiredPermissions.isEmpty()) {
            return true;
        }
        if (userRoles == null || userRoles.isEmpty()) {
            return false;
        }
        Set userRoleIds = userRoles.stream().map(role -> role.getId()).collect(Collectors.toSet());
        userRoleIds.retainAll(requiredPermissions);
        return userRoleIds.size() > 0;
    }

    @Generated
    public NavMenu() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NavMenu)) {
            return false;
        }
        NavMenu other = (NavMenu)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NavMenu;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "NavMenu(super=" + super.toString() + ")";
    }
}

