/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.credit_reference_platform.crp.gateway.portal.configuration;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.gitlab.credit_reference_platform.crp.gateway.mapper.ObjectMapperConfiguration;
import com.gitlab.credit_reference_platform.crp.gateway.portal.model.NavMenu;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ResourceUtils;

@Configuration
public class PortalConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PortalConfiguration.class);

    @Bean
    public NavMenu navMenu() throws Exception {
        String resourceStr = MessageFormat.format("The resource [{0}]", "classpath:portal_nav_settings.json");
        ObjectMapper mapper = ObjectMapperConfiguration.createObjectMapper();
        try {
            URL url = ResourceUtils.getURL((String)"classpath:portal_nav_settings.json");
            return (NavMenu)mapper.readValue(url, NavMenu.class);
        }
        catch (FileNotFoundException e1) {
            log.error(resourceStr + " not found for creating NavMenu", (Throwable)e1);
            throw e1;
        }
        catch (JsonParseException | JsonMappingException e2) {
            log.error(resourceStr + " cannot be deserialized as NavMenu", e2);
            throw e2;
        }
        catch (IOException e3) {
            log.error(resourceStr + " cannot be read", (Throwable)e3);
            throw e3;
        }
    }
}

