/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.credit_reference_platform.crp.gateway.portal.aop;

import com.gitlab.credit_reference_platform.crp.gateway.portal.model.NavMenu;
import jakarta.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.context.annotation.Configuration;
import org.springframework.ui.Model;

@Configuration
@Aspect
public class PortalControllerAspect {
    @Resource
    private NavMenu menu;

    @Pointcut(value="execution(* com.gitlab.credit_reference_platform.crp.gateway.portal.controller..*.*(..)) && args(model, ..)")
    public void portalControllerMethod(Model model) {
    }

    @Around(value="portalControllerMethod(model)")
    public Object doAroundRequest(ProceedingJoinPoint pjp, Model model) throws Throwable {
        model.addAttribute("navMenu", (Object)this.menu.toPermissionedMenu());
        return pjp.proceed();
    }
}

