/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.credit_reference_platform.crp.gateway.datasource.configuration;

import com.gitlab.credit_reference_platform.crp.gateway.encryption.utils.SystemEncryptionUtils;
import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import com.mysql.cj.jdbc.Driver;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.SQLServerDialect;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class DataSourceConfiguration {
    public static final String SPRING_DATASOURCE_URL_PROP_KEY = "spring.datasource.url";
    public static final String SPRING_DATASOURCE_USERNAME_PROP_KEY = "spring.datasource.username";
    public static final String SPRING_DATASOURCE_PASSWORD_PROP_KEY = "spring.datasource.password";
    public static final String SPRING_DATASOURCE_DRIVER_PROP_KEY = "spring.datasource.driver-class-name";
    public static final String HIBERNATE_DIALECT_PROP_KEY = "spring.jpa.properties.hibernate.dialect";
    private static final String SQL_SERVER = "sqlserver";
    private static final String MYSQL = "mysql";
    private static final List<String> SUPPORTED_DB_TYPE = Arrays.asList("sqlserver", "mysql");
    private static final Map<String, Class<? extends Dialect>> DIALECT_MAP;
    private static final Map<String, Class<? extends java.sql.Driver>> DRIVER_MAP;
    private static final Pattern JDBC_URL_PATTERN;
    private final String dbType;
    private final String jdbcUrl;
    private final String username;
    private final String password;

    public DataSourceConfiguration(String jdbcUrl, String username, String password) {
        this.jdbcUrl = jdbcUrl;
        this.username = SystemEncryptionUtils.getDecryptedString((String)username);
        this.password = SystemEncryptionUtils.getDecryptedString((String)password);
        String databaseType = null;
        Matcher matcher = JDBC_URL_PATTERN.matcher(jdbcUrl);
        if (matcher.matches()) {
            databaseType = matcher.group("databaseType");
        }
        if (!StringUtils.hasText(databaseType)) {
            throw new IllegalArgumentException("Database type cannot be regonized from JDBC URL");
        }
        DataSourceConfiguration.validDatabaseType((String)databaseType);
        this.dbType = databaseType;
    }

    public static DataSourceConfiguration fromProperties(Properties properties) {
        String jdbcUrl = properties.getProperty("spring.datasource.url");
        String username = properties.getProperty("spring.datasource.username");
        String password = properties.getProperty("spring.datasource.password");
        return new DataSourceConfiguration(jdbcUrl, username, password);
    }

    public Properties toEncryptedProperties() {
        Properties properties = new Properties();
        properties.put("spring.datasource.url", this.jdbcUrl);
        properties.put("spring.datasource.username", SystemEncryptionUtils.getEncryptedString((String)this.username));
        properties.put("spring.datasource.password", SystemEncryptionUtils.getEncryptedString((String)this.password));
        properties.put("spring.datasource.driver-class-name", this.getDriverClassName());
        properties.put("spring.jpa.properties.hibernate.dialect", this.getDialectClassName());
        return properties;
    }

    public Properties toDecryptedProperties() {
        Properties properties = new Properties();
        if (!(StringUtils.hasText((String)this.jdbcUrl) && StringUtils.hasText((String)this.username) && StringUtils.hasText((String)this.password))) {
            return properties;
        }
        properties.put("spring.datasource.url", this.jdbcUrl);
        properties.put("spring.datasource.username", this.username);
        properties.put("spring.datasource.password", this.password);
        properties.put("spring.datasource.driver-class-name", this.getDriverClassName());
        properties.put("spring.jpa.properties.hibernate.dialect", this.getDialectClassName());
        return properties;
    }

    public String getDialectClassName() {
        Class dialect = (Class)DIALECT_MAP.get(this.dbType);
        return dialect != null ? dialect.getName() : null;
    }

    public String getDriverClassName() {
        Class driver = (Class)DRIVER_MAP.get(this.dbType);
        return driver != null ? driver.getName() : null;
    }

    public static void validDatabaseType(String dbType) {
        if (!SUPPORTED_DB_TYPE.contains(dbType)) {
            throw new IllegalStateException(String.format("The database type [%s] is not supported, support types are: %s", dbType, SUPPORTED_DB_TYPE));
        }
    }

    @Generated
    public String toString() {
        return "DataSourceConfiguration(dbType=" + this.dbType + ", jdbcUrl=" + this.jdbcUrl + ")";
    }

    static {
        JDBC_URL_PATTERN = Pattern.compile("^jdbc(:aws-wrapper)?:(?<databaseType>[a-zA-Z0-9]+)://.*$");
        HashMap<String, Class> dialectMap = new HashMap<String, Class>();
        dialectMap.put("sqlserver", SQLServerDialect.class);
        dialectMap.put("mysql", MySQLDialect.class);
        DIALECT_MAP = dialectMap;
        HashMap<String, Class> driverMap = new HashMap<String, Class>();
        driverMap.put("sqlserver", SQLServerDriver.class);
        driverMap.put("mysql", Driver.class);
        DRIVER_MAP = driverMap;
    }
}

