/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.credit_reference_platform.crp.gateway.customize.cub.security.configuration;

import com.gitlab.credit_reference_platform.crp.gateway.system.activity.dto.ActivityDTO;
import com.gitlab.credit_reference_platform.crp.gateway.system.activity.enum_type.ActivityActionType;
import com.gitlab.credit_reference_platform.crp.gateway.system.activity.enum_type.ActivityCategory;
import com.gitlab.credit_reference_platform.crp.gateway.system.activity.enum_type.ActivityStatus;
import com.gitlab.credit_reference_platform.crp.gateway.system.activity.enum_type.ActivityType;
import com.gitlab.credit_reference_platform.crp.gateway.system.activity.service.IActivityService;
import com.gitlab.credit_reference_platform.crp.gateway.usermgmt.service.IUserService;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.Instant;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.stereotype.Component;

@Component
public class SsoAuthenticationFailureHandler
extends SimpleUrlAuthenticationFailureHandler {
    @Autowired
    private IUserService userService;
    @Autowired
    private IActivityService activityService;

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        String username = request.getParameter("UserID");
        String usernamePadded = "005" + StringUtils.leftPad((String)username, (int)5, (String)"0");
        this.userService.incrementLoginFailedCount(usernamePadded);
        this.setDefaultFailureUrl("/error");
        if (org.springframework.util.StringUtils.hasText((String)usernamePadded)) {
            this.insertActivityRecord(usernamePadded);
        }
        this.saveException(request, exception);
        super.onAuthenticationFailure(request, response, exception);
    }

    protected void insertActivityRecord(String username) {
        ActivityDTO activity = new ActivityDTO();
        activity.setCategory(ActivityCategory.SYSTEM);
        activity.setType(ActivityType.USER_LOGIN);
        activity.setActionType(ActivityActionType.ACTION);
        activity.setActivityUsername(username);
        activity.setActivityTime(Instant.now());
        activity.setActivityMessage("Login attempt failed");
        activity.setStatus(ActivityStatus.FAILED);
        this.activityService.insertActivityRecord(activity);
    }
}

