/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.credit_reference_platform.crp.gateway.customize.cub.security.configuration;

import com.gitlab.credit_reference_platform.crp.gateway.customize.cub.security.configuration.SsoAuthenticationToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class SsoAuthFilter
extends AbstractAuthenticationProcessingFilter {
    private static final AntPathRequestMatcher DEFAULT_ANT_PATH_REQUEST_MATCHER = new AntPathRequestMatcher("/login", "GET");

    public SsoAuthFilter() {
        super((RequestMatcher)DEFAULT_ANT_PATH_REQUEST_MATCHER);
    }

    public SsoAuthFilter(AuthenticationManager authenticationManager) {
        super((RequestMatcher)DEFAULT_ANT_PATH_REQUEST_MATCHER, authenticationManager);
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        String employeeId = request.getParameter("UserID");
        String ssoToken = request.getParameter("Token");
        String ip = request.getRemoteAddr();
        String appName = request.getParameter("AppName");
        if (StringUtils.isBlank((CharSequence)employeeId) || StringUtils.isBlank((CharSequence)ssoToken) || StringUtils.isBlank((CharSequence)appName)) {
            throw new BadCredentialsException("UserID, Token, and AppName are required.");
        }
        String employeeIdPadded = "005" + StringUtils.leftPad((String)employeeId, (int)5, (String)"0");
        SsoAuthenticationToken authRequest = new SsoAuthenticationToken(employeeId, employeeIdPadded, ssoToken, ip, appName);
        return this.getAuthenticationManager().authenticate((Authentication)authRequest);
    }
}

