/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.credit_reference_platform.crp.gateway.api.controller;

import com.gitlab.credit_reference_platform.crp.gateway.exception.ServiceException;
import com.gitlab.credit_reference_platform.crp.gateway.icl.service.ICRPParticipantService;
import com.gitlab.credit_reference_platform.crp.gateway.oauth2.service.IOAuth2Service;
import com.gitlab.credit_reference_platform.crp.gateway.sftp.dto.CRPSftpFileInfo;
import com.gitlab.credit_reference_platform.crp.gateway.sftp.dto.CRPSftpMoveFileRequest;
import com.gitlab.credit_reference_platform.crp.gateway.sftp.dto.SftpFileInfo;
import com.gitlab.credit_reference_platform.crp.gateway.sftp.dto.SftpMoveFileRequest;
import com.gitlab.credit_reference_platform.crp.gateway.sftp.enum_type.CRPSftpUploadType;
import com.gitlab.credit_reference_platform.crp.gateway.sftp.service.ISFTPService;
import com.gitlab.credit_reference_platform.crp.gateway.smtp.dto.SMTPEmailContent;
import com.gitlab.credit_reference_platform.crp.gateway.smtp.service.ISMTPService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/api/test"})
public class TestController {
    @Autowired
    private ICRPParticipantService crpParticipantService;
    @Autowired
    private IOAuth2Service oAuth2Service;
    @Autowired
    private ISFTPService sftpService;
    @Autowired
    private ISMTPService smtpService;

    @PostMapping(value={"/crp-connection"})
    public ResponseEntity<?> testCRPClient() throws ServiceException {
        this.crpParticipantService.retrieveCRAParticipantList();
        return ResponseEntity.ok((Object)"Success");
    }

    @PostMapping(value={"/oauth-connection"})
    public ResponseEntity<?> testOAuthConnection(@RequestParam(name="token", required=false) String token) throws ServiceException {
        this.oAuth2Service.verifyToken(token);
        return ResponseEntity.ok((Object)"Success");
    }

    @PostMapping(value={"/sftp/list"})
    public ResponseEntity<?> testSFTPListFiles(@RequestParam(name="directory", required=false) String directory) {
        List files = this.sftpService.listRemoteFileNames(directory);
        return ResponseEntity.ok((Object)files);
    }

    @PostMapping(value={"/sftp/stream"})
    public ResponseEntity<?> testSFTPStreamFile(@RequestParam(name="path", required=true) String path) {
        byte[] fileBytes = this.sftpService.getRemoteFileStream(path);
        return ResponseEntity.ok((Object)new String(fileBytes));
    }

    @PostMapping(value={"/sftp/exist"})
    public ResponseEntity<?> testSFTPFileExist(@RequestParam(name="path", required=true) String path) {
        boolean exists = this.sftpService.isRemoteFileExists(path);
        return ResponseEntity.ok((Object)exists);
    }

    @PostMapping(value={"/sftp/move"})
    public ResponseEntity<?> testSFTPMoveFile(@RequestParam(name="source", required=true) String source, @RequestParam(name="target", required=true) String target) {
        boolean result = this.sftpService.moveRemoteFile(source, target);
        return ResponseEntity.ok((Object)result);
    }

    @PostMapping(value={"/sftp/move/crp"})
    public ResponseEntity<?> testSFTPMoveFile(@RequestParam(name="department", required=true) String department, @RequestParam(name="fromType", required=true) String fromType, @RequestParam(name="toType", required=true) String toType, @RequestParam(name="filename", required=true) String filename) {
        CRPSftpUploadType fromUploadType = CRPSftpUploadType.fromType((String)fromType);
        CRPSftpUploadType toUploadType = CRPSftpUploadType.fromType((String)toType);
        CRPSftpMoveFileRequest moveRequest = new CRPSftpMoveFileRequest(department, fromUploadType, filename, toUploadType);
        boolean result = this.sftpService.moveRemoteFile((SftpMoveFileRequest)moveRequest);
        return ResponseEntity.ok((Object)result);
    }

    @PostMapping(value={"/sftp/get"})
    public ResponseEntity<?> testSFTPListFile(@RequestParam(name="path", required=true) String path) {
        byte[] result = this.sftpService.getRemoteFileStream(path);
        return ResponseEntity.ok((Object)result);
    }

    @PostMapping(value={"/sftp/upload/crp"})
    public ResponseEntity<?> testSFTPUploadCRPFile(@RequestParam(name="department", required=true) String department, @RequestParam(name="filename", required=true) String filename, @RequestParam(name="fileBytes", required=true) byte[] fileBytes) {
        CRPSftpFileInfo fileInfo = new CRPSftpFileInfo(department, CRPSftpUploadType.RECEIVED_FILE, filename);
        String path = this.sftpService.putRemoteFile(fileBytes, (SftpFileInfo)fileInfo);
        return ResponseEntity.ok((Object)path);
    }

    @PostMapping(value={"/smtp/send"})
    public ResponseEntity<?> testSMTPSendEmail(@RequestParam(name="to", required=true) List<String> to, @RequestParam(name="subject", required=true) String subject, @RequestParam(name="content", required=true) String content) {
        SMTPEmailContent email = new SMTPEmailContent();
        email.setToAddrs(to);
        email.setSubject(subject);
        email.setContent(content);
        this.smtpService.sendEmail(email);
        return ResponseEntity.ok((Object)"Sent");
    }
}

