/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.credit_reference_platform.crp.gateway;

import com.gitlab.credit_reference_platform.crp.gateway.startup.CRPApplicationConfigurer;
import com.gitlab.credit_reference_platform.crp.gateway.startup.CRPStartupConfiguration;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.system.ApplicationHome;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@SpringBootApplication(scanBasePackages={"com.gitlab.credit_reference_platform.crp.gateway", "com.gitlab.vincenthung.spring.microservices.http"})
@EnableJpaRepositories(basePackages={"com.gitlab.credit_reference_platform.crp.gateway.**.dao"})
@EnableFeignClients
@EnableScheduling
@EnableConfigurationProperties
@EnableAsync
@EntityScan(value={"com.gitlab.credit_reference_platform.crp.gateway.**.entity"})
public class CreditReferencePlatformGatewayApplication
extends SpringBootServletInitializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CreditReferencePlatformGatewayApplication.class);
    private static final String ARGS_KEY_CONFIGURE = "configure";

    public static void main(String[] args) throws Exception {
        CreditReferencePlatformGatewayApplication.configureBaseDirectory();
        CreditReferencePlatformGatewayApplication.configureApplicationVersion();
        if (args.length > 0) {
            for (String arg : args) {
                if (!"configure".equalsIgnoreCase(arg)) continue;
                CRPApplicationConfigurer.configureStartupProperties();
                return;
            }
        }
        CRPStartupConfiguration.loadApplicationLicense();
        CRPStartupConfiguration.loadStartupProperties();
        CRPStartupConfiguration.processConfigurations();
        SpringApplication.run(CreditReferencePlatformGatewayApplication.class, (String[])args);
    }

    public static void configureApplicationVersion() throws IOException {
        Properties properties = new Properties();
        try {
            properties.load(CreditReferencePlatformGatewayApplication.class.getClassLoader().getResourceAsStream("version.properties"));
        }
        catch (IOException e) {
            log.error("Failed to configure appVersion");
            throw e;
        }
        System.getProperties().put("appVer", properties.get("app.version"));
    }

    public static void configureBaseDirectory() throws Exception {
        String baseDir = System.getProperty("baseDir");
        if (!StringUtils.hasText((String)baseDir)) {
            URL location = CreditReferencePlatformGatewayApplication.class.getProtectionDomain().getCodeSource().getLocation();
            String protocol = location.getProtocol();
            if ("jar".equalsIgnoreCase(protocol)) {
                ApplicationHome home = new ApplicationHome(CreditReferencePlatformGatewayApplication.class);
                baseDir = home.getDir().getPath();
            } else {
                baseDir = new File(location.toURI()).getParent();
            }
            System.getProperties().put("baseDir", baseDir);
        }
        log.info("Configured baseDir = [{}]", (Object)baseDir);
    }
}

